/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.FloatIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.stack.primitive.ImmutableFloatStackFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.FloatStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableFloatArrayStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableFloatEmptyStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableFloatSingletonStack;

public class ImmutableFloatStackFactoryImpl
implements ImmutableFloatStackFactory {
    public static final ImmutableFloatStackFactory INSTANCE = new ImmutableFloatStackFactoryImpl();

    @Override
    public ImmutableFloatStack empty() {
        return ImmutableFloatEmptyStack.INSTANCE;
    }

    @Override
    public ImmutableFloatStack of() {
        return this.empty();
    }

    @Override
    public ImmutableFloatStack with() {
        return this.empty();
    }

    @Override
    public ImmutableFloatStack of(float one) {
        return this.with(one);
    }

    @Override
    public ImmutableFloatStack with(float one) {
        return new ImmutableFloatSingletonStack(one);
    }

    @Override
    public ImmutableFloatStack of(float ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableFloatStack with(float ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableFloatArrayStack.newStackWith(items);
    }

    @Override
    public ImmutableFloatStack ofAll(FloatIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableFloatStack withAll(FloatIterable items) {
        if (items instanceof ImmutableFloatStack) {
            return (ImmutableFloatStack)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableFloatStack ofAll(Iterable<Float> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableFloatStack withAll(Iterable<Float> iterable) {
        return FloatStacks.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableFloatStack ofAllReversed(FloatIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public ImmutableFloatStack withAllReversed(FloatIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableFloatArrayStack.newStackFromTopToBottom(items);
    }
}

