/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.IntIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.stack.primitive.ImmutableIntStackFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.IntStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableIntArrayStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableIntEmptyStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.immutable.primitive.ImmutableIntSingletonStack;
import java.util.stream.IntStream;

public class ImmutableIntStackFactoryImpl
implements ImmutableIntStackFactory {
    public static final ImmutableIntStackFactory INSTANCE = new ImmutableIntStackFactoryImpl();

    @Override
    public ImmutableIntStack empty() {
        return ImmutableIntEmptyStack.INSTANCE;
    }

    @Override
    public ImmutableIntStack of() {
        return this.empty();
    }

    @Override
    public ImmutableIntStack with() {
        return this.empty();
    }

    @Override
    public ImmutableIntStack of(int one) {
        return this.with(one);
    }

    @Override
    public ImmutableIntStack with(int one) {
        return new ImmutableIntSingletonStack(one);
    }

    @Override
    public ImmutableIntStack of(int ... items) {
        return this.with(items);
    }

    @Override
    public ImmutableIntStack with(int ... items) {
        if (items == null || items.length == 0) {
            return this.with();
        }
        if (items.length == 1) {
            return this.with(items[0]);
        }
        return ImmutableIntArrayStack.newStackWith(items);
    }

    @Override
    public ImmutableIntStack ofAll(IntIterable items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntStack withAll(IntIterable items) {
        if (items instanceof ImmutableIntStack) {
            return (ImmutableIntStack)items;
        }
        return this.with(items.toArray());
    }

    @Override
    public ImmutableIntStack ofAll(Iterable<Integer> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public ImmutableIntStack withAll(Iterable<Integer> iterable) {
        return IntStacks.mutable.withAll(iterable).toImmutable();
    }

    @Override
    public ImmutableIntStack ofAllReversed(IntIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public ImmutableIntStack withAllReversed(IntIterable items) {
        if (items == null || items.isEmpty()) {
            return this.with();
        }
        if (items.size() == 1) {
            return this.with(items.toArray());
        }
        return ImmutableIntArrayStack.newStackFromTopToBottom(items);
    }

    @Override
    public ImmutableIntStack ofAll(IntStream items) {
        return this.withAll(items);
    }

    @Override
    public ImmutableIntStack withAll(IntStream items) {
        return this.with(items.toArray());
    }
}

