/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.DoubleIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.stack.primitive.MutableDoubleStackFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableDoubleStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive.DoubleArrayStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.stream.DoubleStream;

public class MutableDoubleStackFactoryImpl
implements MutableDoubleStackFactory {
    public static final MutableDoubleStackFactory INSTANCE = new MutableDoubleStackFactoryImpl();

    @Override
    public MutableDoubleStack empty() {
        return new DoubleArrayStack();
    }

    @Override
    public MutableDoubleStack of() {
        return this.empty();
    }

    @Override
    public MutableDoubleStack with() {
        return this.empty();
    }

    @Override
    public MutableDoubleStack of(double ... items) {
        return this.with(items);
    }

    @Override
    public MutableDoubleStack with(double ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return DoubleArrayStack.newStackWith(items);
    }

    @Override
    public MutableDoubleStack ofAll(DoubleIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableDoubleStack withAll(DoubleIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return DoubleArrayStack.newStack(items);
    }

    @Override
    public MutableDoubleStack ofAll(Iterable<Double> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableDoubleStack withAll(Iterable<Double> iterable) {
        MutableDoubleStack stack = DoubleStacks.mutable.empty();
        Iterate.forEach(iterable, stack::push);
        return stack;
    }

    @Override
    public MutableDoubleStack ofAllReversed(DoubleIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableDoubleStack withAllReversed(DoubleIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return DoubleArrayStack.newStackFromTopToBottom(items);
    }

    @Override
    public MutableDoubleStack ofAll(DoubleStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableDoubleStack withAll(DoubleStream items) {
        return this.with(items.toArray());
    }
}

