/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.LongIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.factory.stack.primitive.MutableLongStackFactory;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.stack.primitive.MutableLongStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.factory.primitive.LongStacks;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.stack.mutable.primitive.LongArrayStack;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.stream.LongStream;

public class MutableLongStackFactoryImpl
implements MutableLongStackFactory {
    public static final MutableLongStackFactory INSTANCE = new MutableLongStackFactoryImpl();

    @Override
    public MutableLongStack empty() {
        return new LongArrayStack();
    }

    @Override
    public MutableLongStack of() {
        return this.empty();
    }

    @Override
    public MutableLongStack with() {
        return this.empty();
    }

    @Override
    public MutableLongStack of(long ... items) {
        return this.with(items);
    }

    @Override
    public MutableLongStack with(long ... items) {
        if (items.length == 0) {
            return this.empty();
        }
        return LongArrayStack.newStackWith(items);
    }

    @Override
    public MutableLongStack ofAll(LongIterable items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongStack withAll(LongIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return LongArrayStack.newStack(items);
    }

    @Override
    public MutableLongStack ofAll(Iterable<Long> iterable) {
        return this.withAll(iterable);
    }

    @Override
    public MutableLongStack withAll(Iterable<Long> iterable) {
        MutableLongStack stack = LongStacks.mutable.empty();
        Iterate.forEach(iterable, stack::push);
        return stack;
    }

    @Override
    public MutableLongStack ofAllReversed(LongIterable items) {
        return this.withAllReversed(items);
    }

    @Override
    public MutableLongStack withAllReversed(LongIterable items) {
        if (items.isEmpty()) {
            return this.empty();
        }
        return LongArrayStack.newStackFromTopToBottom(items);
    }

    @Override
    public MutableLongStack ofAll(LongStream items) {
        return this.withAll(items);
    }

    @Override
    public MutableLongStack withAll(LongStream items) {
        return this.with(items.toArray());
    }
}

