/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.Triple;
import java.util.Objects;

class TripleImpl<T1, T2, T3>
implements Triple<T1, T2, T3> {
    private static final long serialVersionUID = 1L;
    private final T1 one;
    private final T2 two;
    private final T3 three;

    TripleImpl(T1 one, T2 two, T3 three) {
        this.one = one;
        this.two = two;
        this.three = three;
    }

    @Override
    public T1 getOne() {
        return this.one;
    }

    @Override
    public T2 getTwo() {
        return this.two;
    }

    @Override
    public T3 getThree() {
        return this.three;
    }

    @Override
    public TripleImpl<T3, T2, T1> reverse() {
        return new TripleImpl<T3, T2, T1>(this.three, this.two, this.one);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Triple)) {
            return false;
        }
        Triple that = (Triple)o;
        return Objects.equals(this.one, that.getOne()) && Objects.equals(this.two, that.getTwo()) && Objects.equals(this.three, that.getThree());
    }

    public int hashCode() {
        int result = this.one == null ? 0 : this.one.hashCode();
        result = 29 * result + (this.two == null ? 0 : this.two.hashCode());
        result = 43 * result + (this.three == null ? 0 : this.three.hashCode());
        return result;
    }

    public String toString() {
        return this.one + ":" + this.two + ":" + this.three;
    }

    @Override
    public int compareTo(Triple<T1, T2, T3> other) {
        int i = ((Comparable)this.one).compareTo(other.getOne());
        if (i != 0) {
            return i;
        }
        int j = ((Comparable)this.two).compareTo(other.getTwo());
        if (j != 0) {
            return j;
        }
        return ((Comparable)this.three).compareTo(other.getThree());
    }
}

