/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.tuple.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.tuple.primitive.ShortFloatPair;

public class ShortFloatPairImpl
implements ShortFloatPair {
    private static final long serialVersionUID = 1L;
    private final short one;
    private final float two;

    ShortFloatPairImpl(short newOne, float newTwo) {
        this.one = newOne;
        this.two = newTwo;
    }

    @Override
    public short getOne() {
        return this.one;
    }

    @Override
    public float getTwo() {
        return this.two;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShortFloatPair)) {
            return false;
        }
        ShortFloatPair that = (ShortFloatPair)o;
        return this.one == that.getOne() && Float.compare(this.two, that.getTwo()) == 0;
    }

    public int hashCode() {
        return 29 * this.one + Float.floatToIntBits(this.two);
    }

    public String toString() {
        return this.one + ":" + this.two;
    }

    @Override
    public int compareTo(ShortFloatPair that) {
        int i = this.one - that.getOne();
        if (i != 0) {
            return i;
        }
        return Float.compare(this.two, that.getTwo());
    }
}

