/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.internal;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.collection.MutableCollection;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.SetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.MutableSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.set.sorted.SortedSetIterable;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.block.factory.Comparators;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.set.sorted.mutable.TreeSortedSet;
import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.Iterate;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;

public final class SortedSetIterables {
    private SortedSetIterables() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> MutableSortedSet<MutableSortedSet<T>> powerSet(SortedSet<T> set) {
        Comparator<T> comparator = set.comparator();
        TreeSortedSet<T> innerTree = TreeSortedSet.newSet(comparator);
        TreeSortedSet sortedSetIterables = TreeSortedSet.newSet(Comparators.powerSet());
        MutableCollection seed = sortedSetIterables.with(innerTree);
        return Iterate.injectInto(seed, set, (accumulator, element) -> accumulator.union((SetIterable)accumulator.collect(set1 -> {
            MutableSortedSet newSet = set1.clone();
            newSet.add(element);
            return newSet;
        }).toSet()));
    }

    public static <T> ImmutableSortedSet<ImmutableSortedSet<T>> immutablePowerSet(SortedSet<T> set) {
        return SortedSetIterables.powerSet(set).collect(MutableSortedSet::toImmutable, TreeSortedSet.newSet(Comparators.powerSet())).toImmutable();
    }

    public static <T> int compare(SortedSetIterable<T> setA, SortedSetIterable<T> setB) {
        Iterator itrA = setA.iterator();
        Iterator itrB = setB.iterator();
        if (setA.comparator() != null) {
            Comparator comparator = setA.comparator();
            while (itrA.hasNext()) {
                if (itrB.hasNext()) {
                    int val = comparator.compare(itrA.next(), itrB.next());
                    if (val == 0) continue;
                    return val;
                }
                return 1;
            }
            return itrB.hasNext() ? -1 : 0;
        }
        while (itrA.hasNext()) {
            if (itrB.hasNext()) {
                int val = ((Comparable)itrA.next()).compareTo(itrB.next());
                if (val == 0) continue;
                return val;
            }
            return 1;
        }
        return itrB.hasNext() ? -1 : 0;
    }
}

