/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.impl.utility.primitive;

import com.google.cloud.spark.bigquery.repackaged.org.eclipse.collections.api.block.comparator.primitive.ByteComparator;

public final class ByteQuickSort {
    private static final int SORT_SMALL_SIZE = 9;

    private ByteQuickSort() {
    }

    public static void sort(byte[] array, int left, int right, ByteComparator comparator) {
        int size = right - left + 1;
        if (size <= 9) {
            ByteQuickSort.insertionSort(array, left, right, comparator);
        } else {
            int mid = right - right / 2 + left / 2;
            byte leftVal = array[left];
            byte rightVal = array[right];
            byte midVal = array[mid];
            int swapIndex = -1;
            if (comparator.compare(leftVal, midVal) > 0 && comparator.compare(leftVal, rightVal) > 0) {
                swapIndex = comparator.compare(midVal, rightVal) < 0 ? right : mid;
            } else if (comparator.compare(leftVal, midVal) < 0 && comparator.compare(leftVal, rightVal) < 0) {
                int n = swapIndex = comparator.compare(midVal, rightVal) < 0 ? mid : right;
            }
            if (swapIndex > 0) {
                ByteQuickSort.swap(array, left, swapIndex);
            }
            byte pivot = array[left];
            int i = left + 1;
            int j = right;
            while (i < j) {
                while (comparator.compare(array[i], pivot) <= 0 && i < j) {
                    ++i;
                }
                while (comparator.compare(pivot, array[j]) < 0 && j > i - 1) {
                    --j;
                }
                if (i < j) {
                    ByteQuickSort.swap(array, i, j);
                    continue;
                }
                ByteQuickSort.swap(array, left, j);
            }
            if (right > j + 1) {
                int from;
                for (from = j + 1; right > from && comparator.compare(pivot, array[from]) == 0; ++from) {
                }
                if (right > from) {
                    ByteQuickSort.sort(array, from, right, comparator);
                }
            }
            if (left < j - 1) {
                int to;
                for (to = j - 1; to > left && comparator.compare(pivot, array[to]) == 0; --to) {
                }
                if (left < to) {
                    ByteQuickSort.sort(array, left, to, comparator);
                }
            }
        }
    }

    private static void insertionSort(byte[] array, int left, int right, ByteComparator comparator) {
        for (int j = left + 1; j <= right; ++j) {
            if (comparator.compare(array[j - 1], array[j]) <= 0) continue;
            byte key = array[j];
            int i = j - 1;
            do {
                array[i + 1] = array[i];
            } while (--i > -1 && comparator.compare(key, array[i]) < 0);
            array[i + 1] = key;
        }
    }

    private static void swap(byte[] array, int i1, int i2) {
        byte value = array[i1];
        array[i1] = array[i2];
        array[i2] = value;
    }
}

