/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableSet;
import com.google.cloud.spark.bigquery.repackaged.com.google.inject.Injector;
import com.google.cloud.spark.bigquery.v2.BigQueryWriteBuilder;
import com.google.cloud.spark.bigquery.v2.Spark31BigQueryScanBuilder;
import com.google.cloud.spark.bigquery.v2.context.BigQueryDataSourceReaderContext;
import com.google.cloud.spark.bigquery.v2.context.BigQueryDataSourceReaderModule;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.SupportsWrite;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.read.ScanBuilder;
import org.apache.spark.sql.connector.write.LogicalWriteInfo;
import org.apache.spark.sql.connector.write.WriteBuilder;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class Spark31BigQueryTable
implements Table,
SupportsRead,
SupportsWrite {
    public static final ImmutableSet<TableCapability> TABLE_CAPABILITIES = ImmutableSet.of(TableCapability.BATCH_READ, TableCapability.V1_BATCH_WRITE, TableCapability.TRUNCATE);
    protected Injector injector;
    protected Supplier<StructType> schemaSupplier;
    protected TableId tableId;

    public Spark31BigQueryTable(Injector injector, Supplier<StructType> schemaSupplier) {
        this.injector = injector;
        this.schemaSupplier = schemaSupplier;
        SparkBigQueryConfig config = injector.getInstance(SparkBigQueryConfig.class);
        this.tableId = config.getQuery().isPresent() ? null : config.getTableId();
    }

    public ScanBuilder newScanBuilder(CaseInsensitiveStringMap options) {
        BigQueryDataSourceReaderContext ctx = this.createBigQueryDataSourceReaderContext(options);
        return new Spark31BigQueryScanBuilder(ctx);
    }

    protected BigQueryDataSourceReaderContext createBigQueryDataSourceReaderContext(CaseInsensitiveStringMap options) {
        SparkBigQueryConfig tableScanConfig = SparkBigQueryConfig.from((Map<String, String>)options, ImmutableMap.of(), this.injector.getInstance(DataSourceVersion.class), this.injector.getInstance(SparkSession.class), Optional.ofNullable(this.schemaSupplier.get()), true, Optional.ofNullable(this.tableId));
        Injector readerInjector = this.injector.createChildInjector(new BigQueryDataSourceReaderModule(Optional.of(tableScanConfig)));
        BigQueryDataSourceReaderContext ctx = readerInjector.getInstance(BigQueryDataSourceReaderContext.class);
        return ctx;
    }

    public String name() {
        return this.injector.getInstance(SparkBigQueryConfig.class).getTableId().getTable();
    }

    public StructType schema() {
        return this.schemaSupplier.get();
    }

    public Set<TableCapability> capabilities() {
        return TABLE_CAPABILITIES;
    }

    public WriteBuilder newWriteBuilder(LogicalWriteInfo info) {
        return new BigQueryWriteBuilder(this.injector, info, SaveMode.Append);
    }

    public Map<String, String> properties() {
        SparkBigQueryConfig config = this.injector.getInstance(SparkBigQueryConfig.class);
        return ImmutableMap.builder().put("openlineage.dataset.name", BigQueryUtil.friendlyTableName(config.getTableId())).put("openlineage.dataset.namespace", "bigquery").put("openlineage.dataset.storageDatasetFacet.storageLayer", "bigquery").build();
    }
}

