/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2.context;

import com.google.cloud.bigquery.connector.common.BigQueryClientFactory;
import com.google.cloud.bigquery.connector.common.BigQueryStorageReadRowsTracer;
import com.google.cloud.bigquery.connector.common.BigQueryTracerFactory;
import com.google.cloud.bigquery.connector.common.ReadRowsHelper;
import com.google.cloud.bigquery.connector.common.ReadSessionResponse;
import com.google.cloud.spark.bigquery.metrics.SparkBigQueryReadSessionMetrics;
import com.google.cloud.spark.bigquery.metrics.SparkMetricsSource;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Joiner;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.com.google.protobuf.ByteString;
import com.google.cloud.spark.bigquery.v2.context.ArrowColumnBatchPartitionReaderContext;
import com.google.cloud.spark.bigquery.v2.context.InputPartitionContext;
import com.google.cloud.spark.bigquery.v2.context.InputPartitionReaderContext;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.metrics.source.Source;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.vectorized.ColumnarBatch;
import org.apache.spark.util.AccumulatorV2;

public class ArrowInputPartitionContext
implements InputPartitionContext<ColumnarBatch> {
    private final BigQueryClientFactory bigQueryReadClientFactory;
    private final BigQueryTracerFactory tracerFactory;
    private List<String> streamNames;
    private final ReadRowsHelper.Options options;
    private final ImmutableList<String> selectedFields;
    private final ByteString serializedArrowSchema;
    private final com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Optional<StructType> userProvidedSchema;
    private final SparkBigQueryReadSessionMetrics sparkBigQueryReadSessionMetrics;
    private final ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec;

    public ArrowInputPartitionContext(BigQueryClientFactory bigQueryReadClientFactory, BigQueryTracerFactory tracerFactory, List<String> names, ReadRowsHelper.Options options, ImmutableList<String> selectedFields, ReadSessionResponse readSessionResponse, Optional<StructType> userProvidedSchema, SparkBigQueryReadSessionMetrics sparkBigQueryReadSessionMetrics, ReadSession.TableReadOptions.ResponseCompressionCodec responseCompressionCodec) {
        this.bigQueryReadClientFactory = bigQueryReadClientFactory;
        this.streamNames = names;
        this.options = options;
        this.selectedFields = selectedFields;
        this.serializedArrowSchema = readSessionResponse.getReadSession().getArrowSchema().getSerializedSchema();
        this.tracerFactory = tracerFactory;
        this.userProvidedSchema = com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Optional.fromJavaUtil(userProvidedSchema);
        this.sparkBigQueryReadSessionMetrics = sparkBigQueryReadSessionMetrics;
        this.responseCompressionCodec = responseCompressionCodec;
    }

    @Override
    public InputPartitionReaderContext<ColumnarBatch> createPartitionReaderContext() {
        SparkMetricsSource sparkMetricsSource = new SparkMetricsSource();
        TaskContext.get().registerAccumulator((AccumulatorV2)this.sparkBigQueryReadSessionMetrics.getBytesReadAccumulator());
        TaskContext.get().registerAccumulator((AccumulatorV2)this.sparkBigQueryReadSessionMetrics.getRowsReadAccumulator());
        TaskContext.get().registerAccumulator((AccumulatorV2)this.sparkBigQueryReadSessionMetrics.getParseTimeAccumulator());
        TaskContext.get().registerAccumulator((AccumulatorV2)this.sparkBigQueryReadSessionMetrics.getScanTimeAccumulator());
        SparkEnv.get().metricsSystem().registerSource((Source)sparkMetricsSource);
        BigQueryStorageReadRowsTracer tracer = this.tracerFactory.newReadRowsTracer(Joiner.on(",").join(this.streamNames), sparkMetricsSource, Optional.of(this.sparkBigQueryReadSessionMetrics));
        List<ReadRowsRequest.Builder> readRowsRequests = this.streamNames.stream().map(name -> ReadRowsRequest.newBuilder().setReadStream((String)name)).collect(Collectors.toList());
        ReadRowsHelper readRowsHelper = new ReadRowsHelper(this.bigQueryReadClientFactory, readRowsRequests, this.options);
        tracer.startStream();
        Iterator<ReadRowsResponse> readRowsResponses = readRowsHelper.readRows();
        return new ArrowColumnBatchPartitionReaderContext(readRowsResponses, this.serializedArrowSchema, readRowsHelper, this.selectedFields, tracer, this.userProvidedSchema.toJavaUtil(), this.options.numBackgroundThreads(), this.responseCompressionCodec);
    }

    @Override
    public boolean supportColumnarReads() {
        return true;
    }
}

