/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryConnectorException;
import com.google.cloud.spark.bigquery.InjectorBuilder;
import com.google.cloud.spark.bigquery.NoSuchBigQueryTableException;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.json.GoogleJsonResponseException;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.Table;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.BigQueryException;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.DatasetId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.DatasetInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Schema;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.cache.Cache;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.cache.CacheBuilder;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.cache.CacheLoader;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.cache.LoadingCache;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.Streams;
import com.google.cloud.spark.bigquery.repackaged.com.google.inject.Injector;
import com.google.cloud.spark.bigquery.v2.BigQueryIdentifier;
import com.google.cloud.spark.bigquery.v2.Spark35BigQueryTable;
import com.google.cloud.spark.bigquery.v2.Spark3Util;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.StreamSupport;
import org.apache.spark.sql.catalyst.analysis.NamespaceAlreadyExistsException;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchTableException;
import org.apache.spark.sql.catalyst.analysis.NonEmptyNamespaceException;
import org.apache.spark.sql.catalyst.analysis.TableAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.NamespaceChange;
import org.apache.spark.sql.connector.catalog.SupportsNamespaces;
import org.apache.spark.sql.connector.catalog.TableCatalog;
import org.apache.spark.sql.connector.catalog.TableChange;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.sources.DataSourceRegister;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BigQueryCatalog
implements TableCatalog,
SupportsNamespaces {
    private static final Logger logger = LoggerFactory.getLogger(BigQueryCatalog.class);
    private static final String[] DEFAULT_NAMESPACE = new String[]{"default"};
    private static final Cache<String, org.apache.spark.sql.connector.catalog.Table> identifierToTableCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).maximumSize(1000L).build();
    private final LoadingCache<String[], Boolean> datasetExistenceCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(15L, TimeUnit.MINUTES).build(CacheLoader.from(this::bigQueryDatasetExists));
    private TableProvider tableProvider;
    private BigQueryClient bigQueryClient;
    private SchemaConverters schemaConverters;

    public void initialize(String name, CaseInsensitiveStringMap caseInsensitiveStringMap) {
        logger.info("Initializing BigQuery table catalog [{}])", (Object)name);
        Injector injector = new InjectorBuilder().withTableIsMandatory(false).build();
        this.tableProvider = StreamSupport.stream(ServiceLoader.load(DataSourceRegister.class).spliterator(), false).filter(candidate -> candidate.shortName().equals("bigquery")).map(candidate -> (TableProvider)candidate).findFirst().orElseThrow(() -> new IllegalStateException("Could not find a BigQuery TableProvider"));
        this.bigQueryClient = injector.getInstance(BigQueryClient.class);
        this.schemaConverters = SchemaConverters.from(SchemaConvertersConfiguration.from(injector.getInstance(SparkBigQueryConfig.class)));
    }

    public String name() {
        return "bigquery";
    }

    public String[] defaultNamespace() {
        return DEFAULT_NAMESPACE;
    }

    public Identifier[] listTables(String[] namespace) throws NoSuchNamespaceException {
        Preconditions.checkNotNull(namespace, "namespace cannot be null");
        Preconditions.checkArgument(namespace.length == 1, "BigQuery supports only one namespace");
        logger.debug("list tables [{}])", (Object)namespace[0]);
        DatasetId datasetId = DatasetId.of(namespace[0]);
        try {
            return (Identifier[])StreamSupport.stream(this.bigQueryClient.listTables(datasetId, TableDefinition.Type.TABLE).spliterator(), false).map(TableInfo::getTableId).map(BigQueryIdentifier::of).toArray(BigQueryIdentifier[]::new);
        }
        catch (BigQueryException e) {
            GoogleJsonResponseException gsre;
            if (e.getCause() != null && e.getCause() instanceof GoogleJsonResponseException && (gsre = (GoogleJsonResponseException)e.getCause()).getStatusCode() == 404) {
                logger.debug("Dataset does not exist", (Throwable)e);
                throw new NoSuchNamespaceException(namespace);
            }
            throw new BigQueryConnectorException("Error listing tables  in " + Arrays.toString(namespace), e);
        }
    }

    public org.apache.spark.sql.connector.catalog.Table loadTable(Identifier identifier) throws NoSuchTableException {
        logger.debug("loading table [{}])", (Object)this.format(identifier));
        try {
            if (!this.tableExists(identifier)) {
                throw new NoSuchBigQueryTableException(identifier);
            }
            return identifierToTableCache.get(identifier.toString(), () -> Spark3Util.createBigQueryTableInstance(Spark35BigQueryTable::new, null, this.toLoadProperties(identifier)));
        }
        catch (ExecutionException e) {
            throw new BigQueryConnectorException("Problem loading table " + identifier, e);
        }
    }

    Map<String, String> toLoadProperties(Identifier identifier) {
        ImmutableMap.Builder<String, String> result = ImmutableMap.builder();
        switch (identifier.namespace().length) {
            case 1: {
                result.put("dataset", identifier.namespace()[0]);
                break;
            }
            case 2: {
                result.put("project", identifier.namespace()[0]);
                result.put("dataset", identifier.namespace()[1]);
                break;
            }
            default: {
                throw new IllegalArgumentException("The identifier [" + identifier + "] is not recognized by BigQuery");
            }
        }
        result.put("table", identifier.name());
        return result.build();
    }

    public void invalidateTable(Identifier identifier) {
        logger.debug("invalidating table [{}])", (Object)this.format(identifier));
        throw new UnsupportedOperationException("Cannot invalidate table in BigQuery");
    }

    public boolean tableExists(Identifier identifier) {
        logger.debug("checking existence of table [{}])", (Object)this.format(identifier));
        return this.bigQueryClient.tableExists(BigQueryCatalog.toTableId(identifier));
    }

    TableInfo loadBigQueryTable(Identifier identifier) {
        return this.bigQueryClient.getTable(BigQueryCatalog.toTableId(identifier));
    }

    Optional<Table> loadBigQueryRestTable(Identifier identifier) {
        return this.bigQueryClient.getRestTable(BigQueryCatalog.toTableId(identifier));
    }

    public org.apache.spark.sql.connector.catalog.Table createTable(Identifier identifier, StructType structType, Transform[] transforms, Map<String, String> properties) throws TableAlreadyExistsException, NoSuchNamespaceException {
        logger.debug("creating table [{}])", (Object)this.format(identifier));
        if (BigQueryCatalog.tableExplicitlySet(properties)) {
            logger.debug("Mapping Spark table to BigQuery table)");
            try {
                return identifierToTableCache.get(identifier.toString(), () -> Spark3Util.createBigQueryTableInstance(Spark35BigQueryTable::new, null, properties));
            }
            catch (ExecutionException e) {
                throw new BigQueryConnectorException("Error creating table " + identifier, e);
            }
        }
        Schema schema = this.schemaConverters.toBigQuerySchema(structType);
        this.bigQueryClient.createTable(BigQueryCatalog.toTableId(identifier), schema, BigQueryClient.CreateTableOptions.of(Optional.empty(), ImmutableMap.of(), Optional.empty()));
        ImmutableMap.Builder<String, String> getTableProperties = ImmutableMap.builder().putAll(properties);
        if (!BigQueryCatalog.tableExplicitlySet(properties)) {
            getTableProperties.put("dataset", identifier.namespace()[0]).put("table", identifier.name());
        }
        return this.tableProvider.getTable(structType, transforms, getTableProperties.buildKeepingLast());
    }

    private static boolean tableExplicitlySet(Map<String, String> properties) {
        if (properties.containsKey("table")) {
            return true;
        }
        return properties.containsKey("path");
    }

    public org.apache.spark.sql.connector.catalog.Table alterTable(Identifier identifier, TableChange ... tableChanges) throws NoSuchTableException {
        throw new UnsupportedOperationException("Cannot alter table in BigQuery");
    }

    public boolean dropTable(Identifier identifier) {
        logger.debug("dropping table [{}])", (Object)this.format(identifier));
        TableId tableId = BigQueryCatalog.toTableId(identifier);
        if (!this.bigQueryClient.tableExists(tableId)) {
            return false;
        }
        if (this.bigQueryClient.deleteTable(tableId)) {
            identifierToTableCache.invalidate(identifier.toString());
            return true;
        }
        return false;
    }

    public boolean purgeTable(Identifier ident) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot purge table in BigQuery");
    }

    public void renameTable(Identifier oldIdent, Identifier newIdent) throws NoSuchTableException, TableAlreadyExistsException {
        throw new UnsupportedOperationException("Cannot rename table in BigQuery");
    }

    private String format(Identifier identifier) {
        return String.format("%s.%s", Arrays.toString(identifier.namespace()), identifier.name());
    }

    static TableId toTableId(Identifier identifier) {
        if (identifier.namespace().length == 1) {
            return TableId.of(identifier.namespace()[0], identifier.name());
        }
        if (identifier.namespace().length == 2) {
            return TableId.of(identifier.namespace()[0], identifier.namespace()[1], identifier.name());
        }
        throw new IllegalArgumentException("The identifier [" + identifier + "] is not recognized by BigQuery");
    }

    public String[][] listNamespaces() throws NoSuchNamespaceException {
        return (String[][])Streams.stream(this.bigQueryClient.listDatasets()).map(DatasetInfo::getDatasetId).map(this::toNamespace).toArray(x$0 -> new String[x$0][]);
    }

    private String[] toNamespace(DatasetId datasetId) {
        return new String[]{datasetId.getDataset()};
    }

    private DatasetId toDatasetId(String[] namespace) {
        switch (namespace.length) {
            case 1: {
                return DatasetId.of(namespace[0]);
            }
            case 2: {
                return DatasetId.of(namespace[0], namespace[1]);
            }
        }
        throw new IllegalArgumentException("The identifier [" + Arrays.toString(namespace) + "] is not recognized by BigQuery");
    }

    public String[][] listNamespaces(String[] namespace) throws NoSuchNamespaceException {
        switch (namespace.length) {
            case 0: {
                return this.listNamespaces();
            }
            case 1: {
                if (!this.namespaceExists(namespace)) break;
                return new String[0][];
            }
        }
        throw new NoSuchNamespaceException(namespace);
    }

    public boolean namespaceExists(String[] namespace) {
        return this.datasetExistenceCache.getUnchecked(namespace);
    }

    private boolean bigQueryDatasetExists(String[] namespace) {
        return this.bigQueryClient.datasetExists(this.toDatasetId(namespace));
    }

    public Map<String, String> loadNamespaceMetadata(String[] namespace) throws NoSuchNamespaceException {
        DatasetInfo dataset = this.bigQueryClient.getDataset(this.toDatasetId(namespace));
        ImmutableMap.Builder<String, String> result = ImmutableMap.builder();
        result.put("bigquery_location", dataset.getLocation());
        result.put("creationTime", dataset.getCreationTime().toString());
        Optional.ofNullable(dataset.getDescription()).ifPresent(description -> result.put("comment", (String)description));
        return result.build();
    }

    public void createNamespace(String[] namespace, Map<String, String> metadata) throws NamespaceAlreadyExistsException {
        Preconditions.checkArgument(namespace.length == 1, "BigQuery does not support nested namespaces");
        if (this.namespaceExists(namespace)) {
            throw new NamespaceAlreadyExistsException(namespace);
        }
        this.bigQueryClient.createDataset(DatasetId.of(namespace[0]), metadata);
    }

    public void alterNamespace(String[] namespace, NamespaceChange ... changes) throws NoSuchNamespaceException {
    }

    public boolean dropNamespace(String[] namespace, boolean cascade) throws NoSuchNamespaceException, NonEmptyNamespaceException {
        if (!this.namespaceExists(namespace)) {
            throw new NoSuchNamespaceException(namespace);
        }
        if (!cascade && this.listTables(namespace).length > 0) {
            throw new NonEmptyNamespaceException(namespace);
        }
        return this.bigQueryClient.deleteDataset(this.toDatasetId(namespace), cascade);
    }
}

