/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.DataFormatOptions;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.QueryParameter;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.QueryRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.DatasetId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.JobId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Objects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class QueryRequestInfo {
    private QueryJobConfiguration config;
    private final List<ConnectionProperty> connectionProperties;
    private final DatasetId defaultDataset;
    private final Boolean dryRun;
    private final Map<String, String> labels;
    private final Long maximumBytesBilled;
    private final Long maxResults;
    private final String query;
    private final List<QueryParameter> queryParameters;
    private final String requestId;
    private final Boolean createSession;
    private final Boolean useQueryCache;
    private final Boolean useLegacySql;
    private final QueryJobConfiguration.JobCreationMode jobCreationMode;
    private final DataFormatOptions formatOptions;
    private final String reservation;

    QueryRequestInfo(QueryJobConfiguration config, Boolean useInt64Timestamps) {
        this.config = config;
        this.connectionProperties = config.getConnectionProperties();
        this.defaultDataset = config.getDefaultDataset();
        this.dryRun = config.dryRun();
        this.labels = config.getLabels();
        this.maximumBytesBilled = config.getMaximumBytesBilled();
        this.maxResults = config.getMaxResults();
        this.query = config.getQuery();
        this.queryParameters = config.toPb().getQuery().getQueryParameters();
        this.requestId = UUID.randomUUID().toString();
        this.createSession = config.createSession();
        this.useLegacySql = config.useLegacySql();
        this.useQueryCache = config.useQueryCache();
        this.jobCreationMode = config.getJobCreationMode();
        this.formatOptions = new DataFormatOptions().setUseInt64Timestamp(useInt64Timestamps);
        this.reservation = config.getReservation();
    }

    boolean isFastQuerySupported(JobId jobId) {
        if (jobId != null && jobId.getJob() != null) {
            return false;
        }
        return this.config.getClustering() == null && this.config.getCreateDisposition() == null && this.config.getDestinationEncryptionConfiguration() == null && this.config.getDestinationTable() == null && this.config.getJobTimeoutMs() == null && this.config.getMaximumBillingTier() == null && this.config.getPriority() == null && this.config.getRangePartitioning() == null && this.config.getSchemaUpdateOptions() == null && this.config.getTableDefinitions() == null && this.config.getTimePartitioning() == null && this.config.getUserDefinedFunctions() == null && this.config.getWriteDisposition() == null && this.config.getJobCreationMode() != QueryJobConfiguration.JobCreationMode.JOB_CREATION_REQUIRED;
    }

    QueryRequest toPb() {
        QueryRequest request = new QueryRequest();
        if (this.connectionProperties != null) {
            request.setConnectionProperties(Lists.transform(this.connectionProperties, ConnectionProperty.TO_PB_FUNCTION));
        }
        if (this.defaultDataset != null) {
            request.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.dryRun != null) {
            request.setDryRun(this.dryRun);
        }
        if (this.labels != null) {
            request.setLabels(this.labels);
        }
        if (this.maximumBytesBilled != null) {
            request.setMaximumBytesBilled(this.maximumBytesBilled);
        }
        if (this.maxResults != null) {
            request.setMaxResults(this.maxResults);
        }
        request.setQuery(this.query);
        request.setRequestId(this.requestId);
        if (this.queryParameters != null) {
            request.setQueryParameters(this.queryParameters);
        }
        if (this.createSession != null) {
            request.setCreateSession(this.createSession);
        }
        if (this.useLegacySql != null) {
            request.setUseLegacySql(this.useLegacySql);
        }
        if (this.useQueryCache != null) {
            request.setUseQueryCache(this.useQueryCache);
        }
        if (this.jobCreationMode != null) {
            request.setJobCreationMode(this.jobCreationMode.toString());
        }
        if (this.formatOptions != null) {
            request.setFormatOptions(this.formatOptions);
        }
        if (this.reservation != null) {
            request.setReservation(this.reservation);
        }
        return request;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("connectionProperties", this.connectionProperties).add("defaultDataset", this.defaultDataset).add("dryRun", this.dryRun).add("labels", this.labels).add("maximumBytesBilled", this.maximumBytesBilled).add("maxResults", this.maxResults).add("query", this.query).add("requestId", this.requestId).add("queryParameters", this.queryParameters).add("createSession", this.createSession).add("useQueryCache", this.useQueryCache).add("useLegacySql", this.useLegacySql).add("jobCreationMode", (Object)this.jobCreationMode).add("formatOptions", this.formatOptions.getUseInt64Timestamp()).add("reservation", this.reservation).toString();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.connectionProperties, this.defaultDataset, this.dryRun, this.labels, this.maximumBytesBilled, this.maxResults, this.query, this.queryParameters, this.requestId, this.createSession, this.useQueryCache, this.useLegacySql, this.jobCreationMode, this.formatOptions, this.reservation});
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(QueryRequestInfo.class) && java.util.Objects.equals(this.toPb(), ((QueryRequestInfo)obj).toPb());
    }
}

