/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset;

import lombok.Generated;

public final class Naming {
    private Naming() {
    }

    private static String checkArgumentNotEmpty(String value, String fieldName) {
        if (value == null) {
            throw new IllegalArgumentException(fieldName + " cannot be null");
        }
        if (value.trim().isEmpty()) {
            throw new IllegalArgumentException(fieldName + " cannot be empty");
        }
        return value;
    }

    private static <T> T checkNotNull(T value, String fieldName) {
        if (value == null) {
            throw new IllegalArgumentException(fieldName + " cannot be null");
        }
        return value;
    }

    public static interface DatasetNaming {
        public String getNamespace();

        public String getName();
    }

    public static class PubSubNaming
    implements DatasetNaming {
        private final PubSubResourceType resourceType;
        private final String projectId;
        private final String resourceId;

        public PubSubNaming(PubSubResourceType resourceType, String projectId, String resourceId) {
            this.resourceType = (PubSubResourceType)((Object)Naming.checkNotNull((Object)resourceType, "resourceType"));
            this.projectId = Naming.checkArgumentNotEmpty(projectId, "projectId");
            this.resourceId = Naming.checkArgumentNotEmpty(resourceId, "resourceId");
        }

        @Override
        public String getNamespace() {
            return "pubsub";
        }

        @Override
        public String getName() {
            String prefix = this.resourceType == PubSubResourceType.TOPIC ? "topic" : "subscription";
            return String.format("%s:%s:%s", prefix, this.projectId, this.resourceId);
        }

        @Generated
        public static PubSubNamingBuilder builder() {
            return new PubSubNamingBuilder();
        }

        public static enum PubSubResourceType {
            TOPIC,
            SUBSCRIPTION;

        }

        @Generated
        public static class PubSubNamingBuilder {
            @Generated
            private PubSubResourceType resourceType;
            @Generated
            private String projectId;
            @Generated
            private String resourceId;

            @Generated
            PubSubNamingBuilder() {
            }

            @Generated
            public PubSubNamingBuilder resourceType(PubSubResourceType resourceType) {
                this.resourceType = resourceType;
                return this;
            }

            @Generated
            public PubSubNamingBuilder projectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Generated
            public PubSubNamingBuilder resourceId(String resourceId) {
                this.resourceId = resourceId;
                return this;
            }

            @Generated
            public PubSubNaming build() {
                return new PubSubNaming(this.resourceType, this.projectId, this.resourceId);
            }

            @Generated
            public String toString() {
                return "Naming.PubSubNaming.PubSubNamingBuilder(resourceType=" + (Object)((Object)this.resourceType) + ", projectId=" + this.projectId + ", resourceId=" + this.resourceId + ")";
            }
        }
    }

    public static class WASBS
    implements DatasetNaming {
        private final String containerName;
        private final String serviceName;
        private final String objectKey;

        public WASBS(String containerName, String serviceName, String objectKey) {
            this.containerName = Naming.checkArgumentNotEmpty(containerName, "containerName");
            this.serviceName = Naming.checkArgumentNotEmpty(serviceName, "serviceName");
            this.objectKey = Naming.checkArgumentNotEmpty(objectKey, "objectKey");
        }

        @Override
        public String getNamespace() {
            return "wasbs://" + this.containerName + "@" + this.serviceName + ".dfs.core.windows.net";
        }

        @Override
        public String getName() {
            return this.objectKey;
        }

        @Generated
        public static WASBSBuilder builder() {
            return new WASBSBuilder();
        }

        @Generated
        public static class WASBSBuilder {
            @Generated
            private String containerName;
            @Generated
            private String serviceName;
            @Generated
            private String objectKey;

            @Generated
            WASBSBuilder() {
            }

            @Generated
            public WASBSBuilder containerName(String containerName) {
                this.containerName = containerName;
                return this;
            }

            @Generated
            public WASBSBuilder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Generated
            public WASBSBuilder objectKey(String objectKey) {
                this.objectKey = objectKey;
                return this;
            }

            @Generated
            public WASBS build() {
                return new WASBS(this.containerName, this.serviceName, this.objectKey);
            }

            @Generated
            public String toString() {
                return "Naming.WASBS.WASBSBuilder(containerName=" + this.containerName + ", serviceName=" + this.serviceName + ", objectKey=" + this.objectKey + ")";
            }
        }
    }

    public static class S3
    implements DatasetNaming {
        private final String bucketName;
        private final String objectKey;

        public S3(String bucketName, String objectKey) {
            this.bucketName = Naming.checkArgumentNotEmpty(bucketName, "bucketName");
            this.objectKey = Naming.checkArgumentNotEmpty(objectKey, "objectKey");
        }

        @Override
        public String getNamespace() {
            return "s3://" + this.bucketName;
        }

        @Override
        public String getName() {
            return this.objectKey;
        }

        @Generated
        public static S3Builder builder() {
            return new S3Builder();
        }

        @Generated
        public static class S3Builder {
            @Generated
            private String bucketName;
            @Generated
            private String objectKey;

            @Generated
            S3Builder() {
            }

            @Generated
            public S3Builder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            @Generated
            public S3Builder objectKey(String objectKey) {
                this.objectKey = objectKey;
                return this;
            }

            @Generated
            public S3 build() {
                return new S3(this.bucketName, this.objectKey);
            }

            @Generated
            public String toString() {
                return "Naming.S3.S3Builder(bucketName=" + this.bucketName + ", objectKey=" + this.objectKey + ")";
            }
        }
    }

    public static class RemoteFileSystem
    implements DatasetNaming {
        private final String host;
        private final String path;

        public RemoteFileSystem(String host, String path) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.path = Naming.checkArgumentNotEmpty(path, "path");
        }

        @Override
        public String getNamespace() {
            return "file://" + this.host;
        }

        @Override
        public String getName() {
            return this.path;
        }

        @Generated
        public static RemoteFileSystemBuilder builder() {
            return new RemoteFileSystemBuilder();
        }

        @Generated
        public static class RemoteFileSystemBuilder {
            @Generated
            private String host;
            @Generated
            private String path;

            @Generated
            RemoteFileSystemBuilder() {
            }

            @Generated
            public RemoteFileSystemBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public RemoteFileSystemBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public RemoteFileSystem build() {
                return new RemoteFileSystem(this.host, this.path);
            }

            @Generated
            public String toString() {
                return "Naming.RemoteFileSystem.RemoteFileSystemBuilder(host=" + this.host + ", path=" + this.path + ")";
            }
        }
    }

    public static class LocalFileSystem
    implements DatasetNaming {
        private final String path;

        public LocalFileSystem(String path) {
            this.path = Naming.checkArgumentNotEmpty(path, "path");
        }

        @Override
        public String getNamespace() {
            return "file";
        }

        @Override
        public String getName() {
            return this.path;
        }

        @Generated
        public static LocalFileSystemBuilder builder() {
            return new LocalFileSystemBuilder();
        }

        @Generated
        public static class LocalFileSystemBuilder {
            @Generated
            private String path;

            @Generated
            LocalFileSystemBuilder() {
            }

            @Generated
            public LocalFileSystemBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public LocalFileSystem build() {
                return new LocalFileSystem(this.path);
            }

            @Generated
            public String toString() {
                return "Naming.LocalFileSystem.LocalFileSystemBuilder(path=" + this.path + ")";
            }
        }
    }

    public static class Kafka
    implements DatasetNaming {
        private final String bootstrapServerHost;
        private final String port;
        private final String topic;

        public Kafka(String bootstrapServerHost, String port, String topic) {
            this.bootstrapServerHost = Naming.checkArgumentNotEmpty(bootstrapServerHost, "bootstrapServerHost");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.topic = Naming.checkArgumentNotEmpty(topic, "topic");
        }

        @Override
        public String getNamespace() {
            return "kafka://" + this.bootstrapServerHost + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.topic;
        }

        @Generated
        public static KafkaBuilder builder() {
            return new KafkaBuilder();
        }

        @Generated
        public static class KafkaBuilder {
            @Generated
            private String bootstrapServerHost;
            @Generated
            private String port;
            @Generated
            private String topic;

            @Generated
            KafkaBuilder() {
            }

            @Generated
            public KafkaBuilder bootstrapServerHost(String bootstrapServerHost) {
                this.bootstrapServerHost = bootstrapServerHost;
                return this;
            }

            @Generated
            public KafkaBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public KafkaBuilder topic(String topic) {
                this.topic = topic;
                return this;
            }

            @Generated
            public Kafka build() {
                return new Kafka(this.bootstrapServerHost, this.port, this.topic);
            }

            @Generated
            public String toString() {
                return "Naming.Kafka.KafkaBuilder(bootstrapServerHost=" + this.bootstrapServerHost + ", port=" + this.port + ", topic=" + this.topic + ")";
            }
        }
    }

    public static class HDFS
    implements DatasetNaming {
        private final String namenodeHost;
        private final String namenodePort;
        private final String path;

        public HDFS(String namenodeHost, String namenodePort, String path) {
            this.namenodeHost = Naming.checkArgumentNotEmpty(namenodeHost, "namenodeHost");
            this.namenodePort = Naming.checkArgumentNotEmpty(namenodePort, "namenodePort");
            this.path = Naming.checkArgumentNotEmpty(path, "path");
        }

        @Override
        public String getNamespace() {
            return "hdfs://" + this.namenodeHost + ":" + this.namenodePort;
        }

        @Override
        public String getName() {
            return this.path;
        }

        @Generated
        public static HDFSBuilder builder() {
            return new HDFSBuilder();
        }

        @Generated
        public static class HDFSBuilder {
            @Generated
            private String namenodeHost;
            @Generated
            private String namenodePort;
            @Generated
            private String path;

            @Generated
            HDFSBuilder() {
            }

            @Generated
            public HDFSBuilder namenodeHost(String namenodeHost) {
                this.namenodeHost = namenodeHost;
                return this;
            }

            @Generated
            public HDFSBuilder namenodePort(String namenodePort) {
                this.namenodePort = namenodePort;
                return this;
            }

            @Generated
            public HDFSBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public HDFS build() {
                return new HDFS(this.namenodeHost, this.namenodePort, this.path);
            }

            @Generated
            public String toString() {
                return "Naming.HDFS.HDFSBuilder(namenodeHost=" + this.namenodeHost + ", namenodePort=" + this.namenodePort + ", path=" + this.path + ")";
            }
        }
    }

    public static class GCS
    implements DatasetNaming {
        private final String bucketName;
        private final String objectKey;

        public GCS(String bucketName, String objectKey) {
            this.bucketName = Naming.checkArgumentNotEmpty(bucketName, "bucketName");
            this.objectKey = Naming.checkArgumentNotEmpty(objectKey, "objectKey");
        }

        @Override
        public String getNamespace() {
            return "gs://" + this.bucketName;
        }

        @Override
        public String getName() {
            return this.objectKey;
        }

        @Generated
        public static GCSBuilder builder() {
            return new GCSBuilder();
        }

        @Generated
        public static class GCSBuilder {
            @Generated
            private String bucketName;
            @Generated
            private String objectKey;

            @Generated
            GCSBuilder() {
            }

            @Generated
            public GCSBuilder bucketName(String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            @Generated
            public GCSBuilder objectKey(String objectKey) {
                this.objectKey = objectKey;
                return this;
            }

            @Generated
            public GCS build() {
                return new GCS(this.bucketName, this.objectKey);
            }

            @Generated
            public String toString() {
                return "Naming.GCS.GCSBuilder(bucketName=" + this.bucketName + ", objectKey=" + this.objectKey + ")";
            }
        }
    }

    public static class DBFS
    implements DatasetNaming {
        private final String workspace;
        private final String path;

        public DBFS(String workspace, String path) {
            this.workspace = Naming.checkArgumentNotEmpty(workspace, "workspace");
            this.path = Naming.checkArgumentNotEmpty(path, "path");
        }

        @Override
        public String getNamespace() {
            return "dbfs://" + this.workspace;
        }

        @Override
        public String getName() {
            return this.path;
        }

        @Generated
        public static DBFSBuilder builder() {
            return new DBFSBuilder();
        }

        @Generated
        public static class DBFSBuilder {
            @Generated
            private String workspace;
            @Generated
            private String path;

            @Generated
            DBFSBuilder() {
            }

            @Generated
            public DBFSBuilder workspace(String workspace) {
                this.workspace = workspace;
                return this;
            }

            @Generated
            public DBFSBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public DBFS build() {
                return new DBFS(this.workspace, this.path);
            }

            @Generated
            public String toString() {
                return "Naming.DBFS.DBFSBuilder(workspace=" + this.workspace + ", path=" + this.path + ")";
            }
        }
    }

    public static class ABFSS
    implements DatasetNaming {
        private final String container;
        private final String service;
        private final String path;

        public ABFSS(String container, String service, String path) {
            this.container = Naming.checkArgumentNotEmpty(container, "container");
            this.service = Naming.checkArgumentNotEmpty(service, "service");
            this.path = Naming.checkArgumentNotEmpty(path, "path");
        }

        @Override
        public String getNamespace() {
            return "abfss://" + this.container + "@" + this.service + ".dfs.core.windows.net";
        }

        @Override
        public String getName() {
            return this.path;
        }

        @Generated
        public static ABFSSBuilder builder() {
            return new ABFSSBuilder();
        }

        @Generated
        public static class ABFSSBuilder {
            @Generated
            private String container;
            @Generated
            private String service;
            @Generated
            private String path;

            @Generated
            ABFSSBuilder() {
            }

            @Generated
            public ABFSSBuilder container(String container) {
                this.container = container;
                return this;
            }

            @Generated
            public ABFSSBuilder service(String service) {
                this.service = service;
                return this;
            }

            @Generated
            public ABFSSBuilder path(String path) {
                this.path = path;
                return this;
            }

            @Generated
            public ABFSS build() {
                return new ABFSS(this.container, this.service, this.path);
            }

            @Generated
            public String toString() {
                return "Naming.ABFSS.ABFSSBuilder(container=" + this.container + ", service=" + this.service + ", path=" + this.path + ")";
            }
        }
    }

    public static class Trino
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String catalog;
        private final String schema;
        private final String table;

        public Trino(String host, String port, String catalog, String schema, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.catalog = Naming.checkArgumentNotEmpty(catalog, "catalog");
            this.schema = Naming.checkArgumentNotEmpty(schema, "schema");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "trino://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.catalog + "." + this.schema + "." + this.table;
        }

        @Generated
        public static TrinoBuilder builder() {
            return new TrinoBuilder();
        }

        @Generated
        public static class TrinoBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String catalog;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Generated
            TrinoBuilder() {
            }

            @Generated
            public TrinoBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public TrinoBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public TrinoBuilder catalog(String catalog) {
                this.catalog = catalog;
                return this;
            }

            @Generated
            public TrinoBuilder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public TrinoBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public Trino build() {
                return new Trino(this.host, this.port, this.catalog, this.schema, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.Trino.TrinoBuilder(host=" + this.host + ", port=" + this.port + ", catalog=" + this.catalog + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }
    }

    public static class Snowflake
    implements DatasetNaming {
        private final String organizationName;
        private final String accountName;
        private final String database;
        private final String schema;
        private final String table;

        public Snowflake(String organization_name, String accountName, String database, String schema, String table) {
            this.organizationName = Naming.checkArgumentNotEmpty(organization_name, "organizationName");
            this.accountName = Naming.checkArgumentNotEmpty(accountName, "accountName");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.schema = Naming.checkArgumentNotEmpty(schema, "schema");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "snowflake://" + this.organizationName + "-" + this.accountName;
        }

        @Override
        public String getName() {
            return this.database + "." + this.schema + "." + this.table;
        }

        @Generated
        public static SnowflakeBuilder builder() {
            return new SnowflakeBuilder();
        }

        @Generated
        public static class SnowflakeBuilder {
            @Generated
            private String organizationName;
            @Generated
            private String accountName;
            @Generated
            private String database;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Generated
            SnowflakeBuilder() {
            }

            @Generated
            public SnowflakeBuilder organizationName(String organizationName) {
                this.organizationName = organizationName;
                return this;
            }

            @Generated
            public SnowflakeBuilder accountName(String accountName) {
                this.accountName = accountName;
                return this;
            }

            @Generated
            public SnowflakeBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public SnowflakeBuilder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public SnowflakeBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public Snowflake build() {
                return new Snowflake(this.organizationName, this.accountName, this.database, this.schema, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.Snowflake.SnowflakeBuilder(organizationName=" + this.organizationName + ", accountName=" + this.accountName + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }
    }

    public static class Redshift
    implements DatasetNaming {
        private final String clusterIdentifier;
        private final String region;
        private final String port;
        private final String database;
        private final String schema;
        private final String table;

        public Redshift(String clusterIdentifier, String region, String port, String database, String schema, String table) {
            this.clusterIdentifier = Naming.checkArgumentNotEmpty(clusterIdentifier, "clusterIdentifier");
            this.region = Naming.checkArgumentNotEmpty(region, "region");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.schema = Naming.checkArgumentNotEmpty(schema, "schema");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "redshift://" + this.clusterIdentifier + "." + this.region + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.database + "." + this.schema + "." + this.table;
        }

        @Generated
        public static RedshiftBuilder builder() {
            return new RedshiftBuilder();
        }

        @Generated
        public static class RedshiftBuilder {
            @Generated
            private String clusterIdentifier;
            @Generated
            private String region;
            @Generated
            private String port;
            @Generated
            private String database;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Generated
            RedshiftBuilder() {
            }

            @Generated
            public RedshiftBuilder clusterIdentifier(String clusterIdentifier) {
                this.clusterIdentifier = clusterIdentifier;
                return this;
            }

            @Generated
            public RedshiftBuilder region(String region) {
                this.region = region;
                return this;
            }

            @Generated
            public RedshiftBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public RedshiftBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public RedshiftBuilder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public RedshiftBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public Redshift build() {
                return new Redshift(this.clusterIdentifier, this.region, this.port, this.database, this.schema, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.Redshift.RedshiftBuilder(clusterIdentifier=" + this.clusterIdentifier + ", region=" + this.region + ", port=" + this.port + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }
    }

    public static class Teradata
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String database;
        private final String table;

        public Teradata(String host, String port, String database, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "teradata://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.database + "." + this.table;
        }

        @Generated
        public static TeradataBuilder builder() {
            return new TeradataBuilder();
        }

        @Generated
        public static class TeradataBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String database;
            @Generated
            private String table;

            @Generated
            TeradataBuilder() {
            }

            @Generated
            public TeradataBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public TeradataBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public TeradataBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public TeradataBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public Teradata build() {
                return new Teradata(this.host, this.port, this.database, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.Teradata.TeradataBuilder(host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", table=" + this.table + ")";
            }
        }
    }

    public static class Postgres
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String database;
        private final String schema;
        private final String table;

        public Postgres(String host, String port, String database, String schema, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.schema = Naming.checkArgumentNotEmpty(schema, "schema");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "postgres://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.database + "." + this.schema + "." + this.table;
        }

        @Generated
        public static PostgresBuilder builder() {
            return new PostgresBuilder();
        }

        @Generated
        public static class PostgresBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String database;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Generated
            PostgresBuilder() {
            }

            @Generated
            public PostgresBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public PostgresBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public PostgresBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public PostgresBuilder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public PostgresBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public Postgres build() {
                return new Postgres(this.host, this.port, this.database, this.schema, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.Postgres.PostgresBuilder(host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }
    }

    public static class Oracle
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String serviceName;
        private final String schema;
        private final String table;

        public Oracle(String host, String port, String serviceName, String schema, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.serviceName = Naming.checkArgumentNotEmpty(serviceName, "serviceName");
            this.schema = Naming.checkArgumentNotEmpty(schema, "schema");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "oracle://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.serviceName + "." + this.schema + "." + this.table;
        }

        @Generated
        public static OracleBuilder builder() {
            return new OracleBuilder();
        }

        @Generated
        public static class OracleBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String serviceName;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Generated
            OracleBuilder() {
            }

            @Generated
            public OracleBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public OracleBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public OracleBuilder serviceName(String serviceName) {
                this.serviceName = serviceName;
                return this;
            }

            @Generated
            public OracleBuilder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public OracleBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public Oracle build() {
                return new Oracle(this.host, this.port, this.serviceName, this.schema, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.Oracle.OracleBuilder(host=" + this.host + ", port=" + this.port + ", serviceName=" + this.serviceName + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }
    }

    public static class OceanBase
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String database;
        private final String table;

        public OceanBase(String host, String port, String database, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "oceanbase://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.database + "." + this.table;
        }

        @Generated
        public static OceanBaseBuilder builder() {
            return new OceanBaseBuilder();
        }

        @Generated
        public static class OceanBaseBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String database;
            @Generated
            private String table;

            @Generated
            OceanBaseBuilder() {
            }

            @Generated
            public OceanBaseBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public OceanBaseBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public OceanBaseBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public OceanBaseBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public OceanBase build() {
                return new OceanBase(this.host, this.port, this.database, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.OceanBase.OceanBaseBuilder(host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", table=" + this.table + ")";
            }
        }
    }

    public static class DB2
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String database;
        private final String schema;
        private final String table;

        public DB2(String host, String port, String database, String schema, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.schema = Naming.checkArgumentNotEmpty(schema, "schema");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "db2://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.database + "." + this.schema + "." + this.table;
        }

        @Generated
        public static DB2Builder builder() {
            return new DB2Builder();
        }

        @Generated
        public static class DB2Builder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String database;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Generated
            DB2Builder() {
            }

            @Generated
            public DB2Builder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public DB2Builder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public DB2Builder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public DB2Builder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public DB2Builder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public DB2 build() {
                return new DB2(this.host, this.port, this.database, this.schema, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.DB2.DB2Builder(host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }
    }

    public static class CrateDB
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String database;
        private final String schema;
        private final String table;

        public CrateDB(String host, String port, String database, String schema, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.schema = Naming.checkArgumentNotEmpty(schema, "schema");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "crate://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.database + "." + this.schema + "." + this.table;
        }

        @Generated
        public static CrateDBBuilder builder() {
            return new CrateDBBuilder();
        }

        @Generated
        public static class CrateDBBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String database;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Generated
            CrateDBBuilder() {
            }

            @Generated
            public CrateDBBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public CrateDBBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public CrateDBBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public CrateDBBuilder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public CrateDBBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public CrateDB build() {
                return new CrateDB(this.host, this.port, this.database, this.schema, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.CrateDB.CrateDBBuilder(host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }
    }

    public static class MySQL
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String database;
        private final String table;

        public MySQL(String host, String port, String database, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "mysql://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.database + "." + this.table;
        }

        @Generated
        public static MySQLBuilder builder() {
            return new MySQLBuilder();
        }

        @Generated
        public static class MySQLBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String database;
            @Generated
            private String table;

            @Generated
            MySQLBuilder() {
            }

            @Generated
            public MySQLBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public MySQLBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public MySQLBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public MySQLBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public MySQL build() {
                return new MySQL(this.host, this.port, this.database, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.MySQL.MySQLBuilder(host=" + this.host + ", port=" + this.port + ", database=" + this.database + ", table=" + this.table + ")";
            }
        }
    }

    public static class Glue
    implements DatasetNaming {
        private final String region;
        private final String accountId;
        private final String databaseName;
        private final String tableName;

        public Glue(String region, String accountId, String databaseName, String tableName) {
            this.region = Naming.checkArgumentNotEmpty(region, "region");
            this.accountId = Naming.checkArgumentNotEmpty(accountId, "accountId");
            this.databaseName = Naming.checkArgumentNotEmpty(databaseName, "databaseName");
            this.tableName = Naming.checkArgumentNotEmpty(tableName, "tableName");
        }

        @Override
        public String getNamespace() {
            return String.format("arn:aws:glue:%s:%s", this.region, this.accountId);
        }

        @Override
        public String getName() {
            return String.format("table/%s/%s", this.databaseName, this.tableName);
        }

        @Generated
        public static GlueBuilder builder() {
            return new GlueBuilder();
        }

        @Generated
        public static class GlueBuilder {
            @Generated
            private String region;
            @Generated
            private String accountId;
            @Generated
            private String databaseName;
            @Generated
            private String tableName;

            @Generated
            GlueBuilder() {
            }

            @Generated
            public GlueBuilder region(String region) {
                this.region = region;
                return this;
            }

            @Generated
            public GlueBuilder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            @Generated
            public GlueBuilder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            @Generated
            public GlueBuilder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            @Generated
            public Glue build() {
                return new Glue(this.region, this.accountId, this.databaseName, this.tableName);
            }

            @Generated
            public String toString() {
                return "Naming.Glue.GlueBuilder(region=" + this.region + ", accountId=" + this.accountId + ", databaseName=" + this.databaseName + ", tableName=" + this.tableName + ")";
            }
        }
    }

    public static class Cassandra
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String keyspace;
        private final String table;

        public Cassandra(String host, String port, String keyspace, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.keyspace = Naming.checkArgumentNotEmpty(keyspace, "keyspace");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "cassandra://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.keyspace + "." + this.table;
        }

        @Generated
        public static CassandraBuilder builder() {
            return new CassandraBuilder();
        }

        @Generated
        public static class CassandraBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String keyspace;
            @Generated
            private String table;

            @Generated
            CassandraBuilder() {
            }

            @Generated
            public CassandraBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public CassandraBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public CassandraBuilder keyspace(String keyspace) {
                this.keyspace = keyspace;
                return this;
            }

            @Generated
            public CassandraBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public Cassandra build() {
                return new Cassandra(this.host, this.port, this.keyspace, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.Cassandra.CassandraBuilder(host=" + this.host + ", port=" + this.port + ", keyspace=" + this.keyspace + ", table=" + this.table + ")";
            }
        }
    }

    public static class BigQuery
    implements DatasetNaming {
        private final String projectId;
        private final String datasetName;
        private final String tableName;

        public BigQuery(String projectId, String datasetName, String tableName) {
            this.projectId = Naming.checkArgumentNotEmpty(projectId, "projectId");
            this.datasetName = Naming.checkArgumentNotEmpty(datasetName, "datasetName");
            this.tableName = Naming.checkArgumentNotEmpty(tableName, "tableName");
        }

        @Override
        public String getNamespace() {
            return "bigquery";
        }

        @Override
        public String getName() {
            return String.format("%s.%s.%s", this.projectId, this.datasetName, this.tableName);
        }

        @Generated
        public static BigQueryBuilder builder() {
            return new BigQueryBuilder();
        }

        @Generated
        public static class BigQueryBuilder {
            @Generated
            private String projectId;
            @Generated
            private String datasetName;
            @Generated
            private String tableName;

            @Generated
            BigQueryBuilder() {
            }

            @Generated
            public BigQueryBuilder projectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Generated
            public BigQueryBuilder datasetName(String datasetName) {
                this.datasetName = datasetName;
                return this;
            }

            @Generated
            public BigQueryBuilder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            @Generated
            public BigQuery build() {
                return new BigQuery(this.projectId, this.datasetName, this.tableName);
            }

            @Generated
            public String toString() {
                return "Naming.BigQuery.BigQueryBuilder(projectId=" + this.projectId + ", datasetName=" + this.datasetName + ", tableName=" + this.tableName + ")";
            }
        }
    }

    public static class AzureSynapse
    implements DatasetNaming {
        private final String host;
        private final String port;
        private final String schema;
        private final String table;

        public AzureSynapse(String host, String port, String schema, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.port = Naming.checkArgumentNotEmpty(port, "port");
            this.schema = Naming.checkArgumentNotEmpty(schema, "schema");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "sqlserver://" + this.host + ":" + this.port;
        }

        @Override
        public String getName() {
            return this.schema + "." + this.table;
        }

        @Generated
        public static AzureSynapseBuilder builder() {
            return new AzureSynapseBuilder();
        }

        @Generated
        public static class AzureSynapseBuilder {
            @Generated
            private String host;
            @Generated
            private String port;
            @Generated
            private String schema;
            @Generated
            private String table;

            @Generated
            AzureSynapseBuilder() {
            }

            @Generated
            public AzureSynapseBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public AzureSynapseBuilder port(String port) {
                this.port = port;
                return this;
            }

            @Generated
            public AzureSynapseBuilder schema(String schema) {
                this.schema = schema;
                return this;
            }

            @Generated
            public AzureSynapseBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public AzureSynapse build() {
                return new AzureSynapse(this.host, this.port, this.schema, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.AzureSynapse.AzureSynapseBuilder(host=" + this.host + ", port=" + this.port + ", schema=" + this.schema + ", table=" + this.table + ")";
            }
        }
    }

    public static class AzureDataExplorer
    implements DatasetNaming {
        private final String host;
        private final String database;
        private final String table;

        public AzureDataExplorer(String host, String database, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "azurekusto://" + this.host + ".kusto.windows.net";
        }

        @Override
        public String getName() {
            return this.database + "/" + this.table;
        }

        @Generated
        public static AzureDataExplorerBuilder builder() {
            return new AzureDataExplorerBuilder();
        }

        @Generated
        public static class AzureDataExplorerBuilder {
            @Generated
            private String host;
            @Generated
            private String database;
            @Generated
            private String table;

            @Generated
            AzureDataExplorerBuilder() {
            }

            @Generated
            public AzureDataExplorerBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public AzureDataExplorerBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public AzureDataExplorerBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public AzureDataExplorer build() {
                return new AzureDataExplorer(this.host, this.database, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.AzureDataExplorer.AzureDataExplorerBuilder(host=" + this.host + ", database=" + this.database + ", table=" + this.table + ")";
            }
        }
    }

    public static class AzureCosmosDB
    implements DatasetNaming {
        private final String host;
        private final String database;
        private final String table;

        public AzureCosmosDB(String host, String database, String table) {
            this.host = Naming.checkArgumentNotEmpty(host, "host");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "azurecosmos://" + this.host + "/dbs/" + this.database;
        }

        @Override
        public String getName() {
            return "colls/" + this.table;
        }

        @Generated
        public static AzureCosmosDBBuilder builder() {
            return new AzureCosmosDBBuilder();
        }

        @Generated
        public static class AzureCosmosDBBuilder {
            @Generated
            private String host;
            @Generated
            private String database;
            @Generated
            private String table;

            @Generated
            AzureCosmosDBBuilder() {
            }

            @Generated
            public AzureCosmosDBBuilder host(String host) {
                this.host = host;
                return this;
            }

            @Generated
            public AzureCosmosDBBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public AzureCosmosDBBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public AzureCosmosDB build() {
                return new AzureCosmosDB(this.host, this.database, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.AzureCosmosDB.AzureCosmosDBBuilder(host=" + this.host + ", database=" + this.database + ", table=" + this.table + ")";
            }
        }
    }

    public static class AWSGlue
    implements DatasetNaming {
        private final String region;
        private final String accountId;
        private final String databaseName;
        private final String tableName;

        public AWSGlue(String region, String accountId, String databaseName, String tableName) {
            this.region = Naming.checkArgumentNotEmpty(region, "region");
            this.accountId = Naming.checkArgumentNotEmpty(accountId, "accountId");
            this.databaseName = Naming.checkArgumentNotEmpty(databaseName, "databaseName");
            this.tableName = Naming.checkArgumentNotEmpty(tableName, "tableName");
        }

        @Override
        public String getNamespace() {
            return "arn:aws:glue:" + this.region + ":" + this.accountId;
        }

        @Override
        public String getName() {
            return "table/" + this.databaseName + "/" + this.tableName;
        }

        @Generated
        public static AWSGlueBuilder builder() {
            return new AWSGlueBuilder();
        }

        @Generated
        public static class AWSGlueBuilder {
            @Generated
            private String region;
            @Generated
            private String accountId;
            @Generated
            private String databaseName;
            @Generated
            private String tableName;

            @Generated
            AWSGlueBuilder() {
            }

            @Generated
            public AWSGlueBuilder region(String region) {
                this.region = region;
                return this;
            }

            @Generated
            public AWSGlueBuilder accountId(String accountId) {
                this.accountId = accountId;
                return this;
            }

            @Generated
            public AWSGlueBuilder databaseName(String databaseName) {
                this.databaseName = databaseName;
                return this;
            }

            @Generated
            public AWSGlueBuilder tableName(String tableName) {
                this.tableName = tableName;
                return this;
            }

            @Generated
            public AWSGlue build() {
                return new AWSGlue(this.region, this.accountId, this.databaseName, this.tableName);
            }

            @Generated
            public String toString() {
                return "Naming.AWSGlue.AWSGlueBuilder(region=" + this.region + ", accountId=" + this.accountId + ", databaseName=" + this.databaseName + ", tableName=" + this.tableName + ")";
            }
        }
    }

    public static class Athena
    implements DatasetNaming {
        private final String regionName;
        private final String catalog;
        private final String database;
        private final String table;

        public Athena(String regionName, String catalog, String database, String table) {
            this.regionName = Naming.checkArgumentNotEmpty(regionName, "regionName");
            this.catalog = Naming.checkArgumentNotEmpty(catalog, "catalog");
            this.database = Naming.checkArgumentNotEmpty(database, "database");
            this.table = Naming.checkArgumentNotEmpty(table, "table");
        }

        @Override
        public String getNamespace() {
            return "awsathena://athena." + this.regionName + ".amazonaws.com";
        }

        @Override
        public String getName() {
            return this.catalog + "." + this.database + "." + this.table;
        }

        @Generated
        public static AthenaBuilder builder() {
            return new AthenaBuilder();
        }

        @Generated
        public static class AthenaBuilder {
            @Generated
            private String regionName;
            @Generated
            private String catalog;
            @Generated
            private String database;
            @Generated
            private String table;

            @Generated
            AthenaBuilder() {
            }

            @Generated
            public AthenaBuilder regionName(String regionName) {
                this.regionName = regionName;
                return this;
            }

            @Generated
            public AthenaBuilder catalog(String catalog) {
                this.catalog = catalog;
                return this;
            }

            @Generated
            public AthenaBuilder database(String database) {
                this.database = database;
                return this;
            }

            @Generated
            public AthenaBuilder table(String table) {
                this.table = table;
                return this;
            }

            @Generated
            public Athena build() {
                return new Athena(this.regionName, this.catalog, this.database, this.table);
            }

            @Generated
            public String toString() {
                return "Naming.Athena.AthenaBuilder(regionName=" + this.regionName + ", catalog=" + this.catalog + ", database=" + this.database + ", table=" + this.table + ")";
            }
        }
    }
}

