/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc.JdbcExtractor;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc.JdbcLocation;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DerbyJdbcExtractor
implements JdbcExtractor {
    private static final Pattern DATABASE_NAME_PATTERN = Pattern.compile(".*databaseName=(?<databaseName>[^;]+).*");

    @Override
    public boolean isDefinedAt(String jdbcUri) {
        return jdbcUri.startsWith("derby:");
    }

    @Override
    public JdbcLocation extract(String rawUri, Properties properties) throws URISyntaxException {
        Matcher databaseNameMatcher = DATABASE_NAME_PATTERN.matcher(rawUri);
        String databaseName = "metastore_db";
        if (databaseNameMatcher.find()) {
            databaseName = databaseNameMatcher.group("databaseName");
        }
        String derbyHome = Optional.ofNullable(System.getProperty("derby.system.home")).orElse(System.getProperty("user.dir"));
        String derbyLocation = new URI(derbyHome + File.separator + databaseName).normalize().getPath();
        return new JdbcLocation("file", Optional.empty(), Optional.of(derbyLocation), Optional.empty());
    }
}

