/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.ArrowBuf;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.BufferAllocator;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BaseFixedWidthVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BaseIntVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BitVectorHelper;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.NullCheckingForGet;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ValueIterableVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ValueVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.impl.UInt1ReaderImpl;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.reader.FieldReader;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.holders.NullableUInt1Holder;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.holders.UInt1Holder;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.Types;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.Field;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.FieldType;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.TransferPair;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.ValueVectorUtility;

public final class UInt1Vector
extends BaseFixedWidthVector
implements BaseIntVector,
ValueIterableVector<Byte> {
    public static final int PROMOTION_MASK = 255;
    public static final byte MAX_UINT1 = -1;
    public static final byte TYPE_WIDTH = 1;

    public UInt1Vector(String name, BufferAllocator allocator) {
        this(name, FieldType.nullable(Types.MinorType.UINT1.getType()), allocator);
    }

    public UInt1Vector(String name, FieldType fieldType, BufferAllocator allocator) {
        this(new Field(name, fieldType, null), allocator);
    }

    public UInt1Vector(Field field, BufferAllocator allocator) {
        super(field, allocator, 1);
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new UInt1ReaderImpl(this);
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.UINT1;
    }

    public static short getNoOverflow(ArrowBuf buffer, int index) {
        byte b = buffer.getByte(index * 1);
        return (short)(0xFF & b);
    }

    public byte get(int index) throws IllegalStateException {
        if (NullCheckingForGet.NULL_CHECKING_ENABLED && this.isSet(index) == 0) {
            throw new IllegalStateException("Value at index is null");
        }
        return this.valueBuffer.getByte(index * 1);
    }

    public void get(int index, NullableUInt1Holder holder) {
        if (this.isSet(index) == 0) {
            holder.isSet = 0;
            return;
        }
        holder.isSet = 1;
        holder.value = this.valueBuffer.getByte(index * 1);
    }

    @Override
    public Byte getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return this.valueBuffer.getByte(index * 1);
    }

    public Short getObjectNoOverflow(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        return UInt1Vector.getNoOverflow(this.valueBuffer, index);
    }

    private void setValue(int index, int value) {
        this.valueBuffer.setByte((long)(index * 1), value);
    }

    private void setValue(int index, byte value) {
        this.valueBuffer.setByte((long)(index * 1), value);
    }

    public void set(int index, int value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, byte value) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, value);
    }

    public void set(int index, NullableUInt1Holder holder) throws IllegalArgumentException {
        if (holder.isSet < 0) {
            throw new IllegalArgumentException();
        }
        if (holder.isSet > 0) {
            BitVectorHelper.setBit(this.validityBuffer, index);
            this.setValue(index, holder.value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void set(int index, UInt1Holder holder) {
        BitVectorHelper.setBit(this.validityBuffer, index);
        this.setValue(index, holder.value);
    }

    public void setSafe(int index, int value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, byte value) {
        this.handleSafe(index);
        this.set(index, value);
    }

    public void setSafe(int index, NullableUInt1Holder holder) throws IllegalArgumentException {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void setSafe(int index, UInt1Holder holder) {
        this.handleSafe(index);
        this.set(index, holder);
    }

    public void set(int index, int isSet, byte value) {
        if (isSet > 0) {
            this.set(index, value);
        } else {
            BitVectorHelper.unsetBit(this.validityBuffer, index);
        }
    }

    public void setSafe(int index, int isSet, byte value) {
        this.handleSafe(index);
        this.set(index, isSet, value);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return new TransferImpl(ref, allocator);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return new TransferImpl(field, allocator);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector to) {
        return new TransferImpl((UInt1Vector)to);
    }

    @Override
    public void setWithPossibleTruncate(int index, long value) {
        this.setSafe(index, (int)value);
    }

    @Override
    public void setUnsafeWithPossibleTruncate(int index, long value) {
        this.set(index, (int)value);
    }

    @Override
    public long getValueAsLong(int index) {
        return this.get(index) & 0xFF;
    }

    @Override
    public String toString() {
        return ValueVectorUtility.getToString(this, 0, this.getValueCount(), (v, i) -> v.getObjectNoOverflow((int)i));
    }

    private class TransferImpl
    implements TransferPair {
        UInt1Vector to;

        public TransferImpl(String ref, BufferAllocator allocator) {
            this.to = new UInt1Vector(ref, UInt1Vector.this.field.getFieldType(), allocator);
        }

        public TransferImpl(Field field, BufferAllocator allocator) {
            this.to = new UInt1Vector(field, allocator);
        }

        public TransferImpl(UInt1Vector to) {
            this.to = to;
        }

        @Override
        public UInt1Vector getTo() {
            return this.to;
        }

        @Override
        public void transfer() {
            UInt1Vector.this.transferTo(this.to);
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            UInt1Vector.this.splitAndTransferTo(startIndex, length, this.to);
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            this.to.copyFromSafe(fromIndex, toIndex, UInt1Vector.this);
        }
    }
}

