/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.services;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.batch.BatchRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.GenericUrl;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.ObjectParser;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Strings;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.Credentials;
import com.google.cloud.spark.bigquery.repackaged.com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractGoogleClient {
    private static final Logger logger = Logger.getLogger(AbstractGoogleClient.class.getName());
    private static final String GOOGLE_CLOUD_UNIVERSE_DOMAIN = "GOOGLE_CLOUD_UNIVERSE_DOMAIN";
    private final HttpRequestFactory requestFactory;
    private final GoogleClientRequestInitializer googleClientRequestInitializer;
    private final String rootUrl;
    private final String servicePath;
    private final String batchPath;
    private final String applicationName;
    private final ObjectParser objectParser;
    private final boolean suppressPatternChecks;
    private final boolean suppressRequiredParameterChecks;
    private final String universeDomain;
    private final HttpRequestInitializer httpRequestInitializer;

    protected AbstractGoogleClient(Builder builder) {
        this.googleClientRequestInitializer = builder.googleClientRequestInitializer;
        this.universeDomain = this.determineUniverseDomain(builder);
        this.rootUrl = AbstractGoogleClient.normalizeRootUrl(this.determineEndpoint(builder));
        this.servicePath = AbstractGoogleClient.normalizeServicePath(builder.servicePath);
        this.batchPath = builder.batchPath;
        if (Strings.isNullOrEmpty(builder.applicationName)) {
            logger.warning("Application name is not set. Call Builder#setApplicationName.");
        }
        this.applicationName = builder.applicationName;
        this.requestFactory = builder.httpRequestInitializer == null ? builder.transport.createRequestFactory() : builder.transport.createRequestFactory(builder.httpRequestInitializer);
        this.objectParser = builder.objectParser;
        this.suppressPatternChecks = builder.suppressPatternChecks;
        this.suppressRequiredParameterChecks = builder.suppressRequiredParameterChecks;
        this.httpRequestInitializer = builder.httpRequestInitializer;
    }

    private String determineUniverseDomain(Builder builder) {
        String resolvedUniverseDomain = builder.universeDomain;
        if (resolvedUniverseDomain == null) {
            resolvedUniverseDomain = System.getenv(GOOGLE_CLOUD_UNIVERSE_DOMAIN);
        }
        return resolvedUniverseDomain == null ? "googleapis.com" : resolvedUniverseDomain;
    }

    private String determineEndpoint(Builder builder) {
        boolean mtlsEnabled = builder.rootUrl.contains(".mtls.");
        if (mtlsEnabled && !this.universeDomain.equals("googleapis.com")) {
            throw new IllegalStateException("mTLS is not supported in any universe other than googleapis.com");
        }
        if (builder.isUserConfiguredEndpoint || builder.serviceName == null) {
            return builder.rootUrl;
        }
        if (mtlsEnabled) {
            return "https://" + builder.serviceName + ".mtls." + this.universeDomain + "/";
        }
        return "https://" + builder.serviceName + "." + this.universeDomain + "/";
    }

    public void validateUniverseDomain() throws IOException {
        if (!(this.httpRequestInitializer instanceof HttpCredentialsAdapter)) {
            return;
        }
        Credentials credentials = ((HttpCredentialsAdapter)this.httpRequestInitializer).getCredentials();
        String expectedUniverseDomain = credentials.getUniverseDomain();
        if (!expectedUniverseDomain.equals(this.getUniverseDomain())) {
            throw new IllegalStateException(String.format("The configured universe domain (%s) does not match the universe domain found in the credentials (%s). If you haven't configured the universe domain explicitly, `googleapis.com` is the default.", this.getUniverseDomain(), expectedUniverseDomain));
        }
    }

    public final String getRootUrl() {
        return this.rootUrl;
    }

    public final String getServicePath() {
        return this.servicePath;
    }

    public final String getBaseUrl() {
        return this.rootUrl + this.servicePath;
    }

    public final String getApplicationName() {
        return this.applicationName;
    }

    public final HttpRequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public final GoogleClientRequestInitializer getGoogleClientRequestInitializer() {
        return this.googleClientRequestInitializer;
    }

    public final String getUniverseDomain() {
        return this.universeDomain;
    }

    public ObjectParser getObjectParser() {
        return this.objectParser;
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        this.validateUniverseDomain();
        if (this.getGoogleClientRequestInitializer() != null) {
            this.getGoogleClientRequestInitializer().initialize(httpClientRequest);
        }
    }

    public final BatchRequest batch() {
        return this.batch(null);
    }

    public final BatchRequest batch(HttpRequestInitializer httpRequestInitializer) {
        BatchRequest batch = new BatchRequest(this.getRequestFactory().getTransport(), httpRequestInitializer);
        if (Strings.isNullOrEmpty(this.batchPath)) {
            batch.setBatchUrl(new GenericUrl(this.getRootUrl() + "batch"));
        } else {
            batch.setBatchUrl(new GenericUrl(this.getRootUrl() + this.batchPath));
        }
        return batch;
    }

    public final boolean getSuppressPatternChecks() {
        return this.suppressPatternChecks;
    }

    public final boolean getSuppressRequiredParameterChecks() {
        return this.suppressRequiredParameterChecks;
    }

    static String normalizeRootUrl(String rootUrl) {
        Preconditions.checkNotNull(rootUrl, "root URL cannot be null.");
        if (!rootUrl.endsWith("/")) {
            rootUrl = rootUrl + "/";
        }
        return rootUrl;
    }

    static String normalizeServicePath(String servicePath) {
        Preconditions.checkNotNull(servicePath, "service path cannot be null");
        if (servicePath.length() == 1) {
            Preconditions.checkArgument("/".equals(servicePath), "service path must equal \"/\" if it is of length 1.");
            servicePath = "";
        } else if (servicePath.length() > 0) {
            if (!servicePath.endsWith("/")) {
                servicePath = servicePath + "/";
            }
            if (servicePath.startsWith("/")) {
                servicePath = servicePath.substring(1);
            }
        }
        return servicePath;
    }

    public static abstract class Builder {
        final HttpTransport transport;
        GoogleClientRequestInitializer googleClientRequestInitializer;
        HttpRequestInitializer httpRequestInitializer;
        final ObjectParser objectParser;
        String rootUrl;
        String servicePath;
        String batchPath;
        String applicationName;
        boolean suppressPatternChecks;
        boolean suppressRequiredParameterChecks;
        String universeDomain;
        Pattern defaultEndpointRegex = Pattern.compile("https://([a-zA-Z]*)(\\.mtls)?\\.googleapis.com/?");
        boolean isUserConfiguredEndpoint;
        String serviceName;

        protected Builder(HttpTransport transport, String rootUrl, String servicePath, ObjectParser objectParser, HttpRequestInitializer httpRequestInitializer) {
            this.transport = Preconditions.checkNotNull(transport);
            this.objectParser = objectParser;
            this.rootUrl = AbstractGoogleClient.normalizeRootUrl(rootUrl);
            this.servicePath = AbstractGoogleClient.normalizeServicePath(servicePath);
            this.httpRequestInitializer = httpRequestInitializer;
            Matcher matcher = this.defaultEndpointRegex.matcher(rootUrl);
            boolean matches = matcher.matches();
            this.isUserConfiguredEndpoint = !matches;
            this.serviceName = matches ? matcher.group(1) : null;
        }

        public abstract AbstractGoogleClient build();

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public ObjectParser getObjectParser() {
            return this.objectParser;
        }

        public final String getRootUrl() {
            return this.rootUrl;
        }

        public Builder setRootUrl(String rootUrl) {
            this.isUserConfiguredEndpoint = true;
            this.rootUrl = AbstractGoogleClient.normalizeRootUrl(rootUrl);
            return this;
        }

        public final String getServicePath() {
            return this.servicePath;
        }

        public Builder setServicePath(String servicePath) {
            this.servicePath = AbstractGoogleClient.normalizeServicePath(servicePath);
            return this;
        }

        public Builder setBatchPath(String batchPath) {
            this.batchPath = batchPath;
            return this;
        }

        public final GoogleClientRequestInitializer getGoogleClientRequestInitializer() {
            return this.googleClientRequestInitializer;
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            this.googleClientRequestInitializer = googleClientRequestInitializer;
            return this;
        }

        public final HttpRequestInitializer getHttpRequestInitializer() {
            return this.httpRequestInitializer;
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            this.httpRequestInitializer = httpRequestInitializer;
            return this;
        }

        public final String getApplicationName() {
            return this.applicationName;
        }

        public Builder setApplicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final boolean getSuppressPatternChecks() {
            return this.suppressPatternChecks;
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            this.suppressPatternChecks = suppressPatternChecks;
            return this;
        }

        public final boolean getSuppressRequiredParameterChecks() {
            return this.suppressRequiredParameterChecks;
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            this.suppressRequiredParameterChecks = suppressRequiredParameterChecks;
            return this;
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return this.setSuppressPatternChecks(true).setSuppressRequiredParameterChecks(true);
        }

        public Builder setUniverseDomain(String universeDomain) {
            if (universeDomain != null && universeDomain.isEmpty()) {
                throw new IllegalArgumentException("The universe domain value cannot be empty.");
            }
            this.universeDomain = universeDomain;
            return this;
        }

        @VisibleForTesting
        String getServiceName() {
            return this.serviceName;
        }
    }
}

