/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.httpjson;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.InternalExtensionOnly;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spark.bigquery.repackaged.com.google.rpc.Code;
import java.util.Objects;

@InternalExtensionOnly
public class HttpJsonStatusCode
implements StatusCode {
    private final int httpStatus;
    private final StatusCode.Code statusCode;

    public static HttpJsonStatusCode of(int httpStatus) {
        return new HttpJsonStatusCode(httpStatus, HttpJsonStatusCode.httpStatusToStatusCode(httpStatus));
    }

    public static HttpJsonStatusCode of(StatusCode.Code statusCode) {
        return new HttpJsonStatusCode(statusCode.getHttpStatusCode(), statusCode);
    }

    public static HttpJsonStatusCode of(Code rpcCode) {
        return HttpJsonStatusCode.of(HttpJsonStatusCode.rpcCodeToStatusCode(rpcCode));
    }

    static StatusCode.Code rpcCodeToStatusCode(Code rpcCode) {
        switch (rpcCode) {
            case OK: {
                return StatusCode.Code.OK;
            }
            case CANCELLED: {
                return StatusCode.Code.CANCELLED;
            }
            case UNKNOWN: {
                return StatusCode.Code.UNKNOWN;
            }
            case INVALID_ARGUMENT: {
                return StatusCode.Code.INVALID_ARGUMENT;
            }
            case DEADLINE_EXCEEDED: {
                return StatusCode.Code.DEADLINE_EXCEEDED;
            }
            case NOT_FOUND: {
                return StatusCode.Code.NOT_FOUND;
            }
            case ALREADY_EXISTS: {
                return StatusCode.Code.ALREADY_EXISTS;
            }
            case PERMISSION_DENIED: {
                return StatusCode.Code.PERMISSION_DENIED;
            }
            case RESOURCE_EXHAUSTED: {
                return StatusCode.Code.RESOURCE_EXHAUSTED;
            }
            case FAILED_PRECONDITION: {
                return StatusCode.Code.FAILED_PRECONDITION;
            }
            case ABORTED: {
                return StatusCode.Code.ABORTED;
            }
            case OUT_OF_RANGE: {
                return StatusCode.Code.OUT_OF_RANGE;
            }
            case UNIMPLEMENTED: {
                return StatusCode.Code.UNIMPLEMENTED;
            }
            case INTERNAL: {
                return StatusCode.Code.INTERNAL;
            }
            case UNAVAILABLE: {
                return StatusCode.Code.UNAVAILABLE;
            }
            case DATA_LOSS: {
                return StatusCode.Code.DATA_LOSS;
            }
            case UNAUTHENTICATED: {
                return StatusCode.Code.UNAUTHENTICATED;
            }
        }
        throw new IllegalArgumentException("Unrecognized rpc code: " + rpcCode);
    }

    static StatusCode.Code httpStatusToStatusCode(int httpStatus) {
        if (200 <= httpStatus && httpStatus < 300) {
            return StatusCode.Code.OK;
        }
        if (400 <= httpStatus && httpStatus < 500) {
            switch (httpStatus) {
                case 400: {
                    return StatusCode.Code.INVALID_ARGUMENT;
                }
                case 401: {
                    return StatusCode.Code.UNAUTHENTICATED;
                }
                case 403: {
                    return StatusCode.Code.PERMISSION_DENIED;
                }
                case 404: {
                    return StatusCode.Code.NOT_FOUND;
                }
                case 409: {
                    return StatusCode.Code.ABORTED;
                }
                case 416: {
                    return StatusCode.Code.OUT_OF_RANGE;
                }
                case 429: {
                    return StatusCode.Code.RESOURCE_EXHAUSTED;
                }
                case 499: {
                    return StatusCode.Code.CANCELLED;
                }
            }
            return StatusCode.Code.FAILED_PRECONDITION;
        }
        if (500 <= httpStatus && httpStatus < 600) {
            switch (httpStatus) {
                case 501: {
                    return StatusCode.Code.UNIMPLEMENTED;
                }
                case 503: {
                    return StatusCode.Code.UNAVAILABLE;
                }
                case 504: {
                    return StatusCode.Code.DEADLINE_EXCEEDED;
                }
            }
            return StatusCode.Code.INTERNAL;
        }
        return StatusCode.Code.UNKNOWN;
    }

    @Override
    public StatusCode.Code getCode() {
        return this.statusCode;
    }

    @Override
    public Integer getTransportCode() {
        return this.httpStatus;
    }

    private HttpJsonStatusCode(int httpStatus, StatusCode.Code statusCode) {
        this.httpStatus = httpStatus;
        this.statusCode = statusCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpJsonStatusCode that = (HttpJsonStatusCode)o;
        return Objects.equals((Object)this.statusCode, (Object)that.statusCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.statusCode});
    }

    public String toString() {
        return "HttpJsonStatusCode{statusCode=" + (Object)((Object)this.statusCode) + "}";
    }
}

