/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.DateTime;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.BetaApi;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.SnapshotDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.Table;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.AutoValue;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.AutoValue_SnapshotTableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.Clustering;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TimePartitioning;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;

@BetaApi
@AutoValue
public abstract class SnapshotTableDefinition
extends TableDefinition {
    private static final long serialVersionUID = 2113445776046717526L;

    @Nullable
    public abstract TableId getBaseTableId();

    @Nullable
    public abstract String getSnapshotTime();

    @Nullable
    public abstract TimePartitioning getTimePartitioning();

    @Nullable
    public abstract RangePartitioning getRangePartitioning();

    @Nullable
    public abstract Clustering getClustering();

    public static Builder newBuilder() {
        return new AutoValue_SnapshotTableDefinition.Builder().setType(TableDefinition.Type.SNAPSHOT);
    }

    @Override
    @VisibleForTesting
    public abstract Builder toBuilder();

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        SnapshotDefinition snapshotDefinition = new SnapshotDefinition();
        snapshotDefinition.setBaseTableReference(this.getBaseTableId().toPb());
        snapshotDefinition.setSnapshotTime(DateTime.parseRfc3339(this.getSnapshotTime()));
        tablePb.setSnapshotDefinition(snapshotDefinition);
        if (this.getTimePartitioning() != null) {
            tablePb.setTimePartitioning(this.getTimePartitioning().toPb());
        }
        if (this.getRangePartitioning() != null) {
            tablePb.setRangePartitioning(this.getRangePartitioning().toPb());
        }
        if (this.getClustering() != null) {
            tablePb.setClustering(this.getClustering().toPb());
        }
        return tablePb;
    }

    static SnapshotTableDefinition fromPb(Table tablePb) {
        Builder builder = (Builder)SnapshotTableDefinition.newBuilder().table(tablePb);
        SnapshotDefinition snapshotDefinition = tablePb.getSnapshotDefinition();
        if (snapshotDefinition != null) {
            if (snapshotDefinition.getBaseTableReference() != null) {
                builder.setBaseTableId(TableId.fromPb(snapshotDefinition.getBaseTableReference()));
            }
            if (snapshotDefinition.getSnapshotTime() != null) {
                builder.setSnapshotTime(snapshotDefinition.getSnapshotTime().toStringRfc3339());
            }
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends TableDefinition.Builder<SnapshotTableDefinition, Builder> {
        public abstract Builder setBaseTableId(TableId var1);

        public abstract Builder setSnapshotTime(String var1);

        public abstract Builder setTimePartitioning(TimePartitioning var1);

        public abstract Builder setRangePartitioning(RangePartitioning var1);

        public abstract Builder setClustering(Clustering var1);

        @Override
        public abstract SnapshotTableDefinition build();
    }
}

