/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.v2;

import com.google.cloud.spark.bigquery.v2.BigQueryStreamingWriterFactory;
import com.google.cloud.spark.bigquery.v2.Spark31BigQueryWriterCommitMessage;
import com.google.cloud.spark.bigquery.write.context.DataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.WriterCommitMessageContext;
import java.util.stream.Stream;
import org.apache.spark.sql.connector.write.PhysicalWriteInfo;
import org.apache.spark.sql.connector.write.WriterCommitMessage;
import org.apache.spark.sql.connector.write.streaming.StreamingDataWriterFactory;
import org.apache.spark.sql.connector.write.streaming.StreamingWrite;

public class BigQueryStreamingWrite
implements StreamingWrite {
    private final DataSourceWriterContext ctx;

    public BigQueryStreamingWrite(DataSourceWriterContext ctx) {
        this.ctx = ctx;
    }

    public StreamingDataWriterFactory createStreamingWriterFactory(PhysicalWriteInfo info) {
        return new BigQueryStreamingWriterFactory(this.ctx.createWriterContextFactory());
    }

    public void commit(long epochId, WriterCommitMessage[] messages) {
        this.ctx.onDataStreamingWriterCommit(epochId, this.toWriterCommitMessageContextArray(messages));
    }

    public void abort(long epochId, WriterCommitMessage[] messages) {
        this.ctx.onDataStreamingWriterAbort(epochId, this.toWriterCommitMessageContextArray(messages));
    }

    private WriterCommitMessageContext toWriterCommitMessageContext(WriterCommitMessage message) {
        return ((Spark31BigQueryWriterCommitMessage)message).getContext();
    }

    private WriterCommitMessageContext[] toWriterCommitMessageContextArray(WriterCommitMessage[] messages) {
        return (WriterCommitMessageContext[])Stream.of(messages).map(this::toWriterCommitMessageContext).toArray(WriterCommitMessageContext[]::new);
    }
}

