/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.spark.bigquery.SchemaConverters;
import com.google.cloud.spark.bigquery.SchemaConvertersConfiguration;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableInfo;
import java.math.BigInteger;
import java.util.Optional;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.InsertableRelation;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BigQueryInsertableRelationBase
extends BaseRelation
implements InsertableRelation {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final BigQueryClient bigQueryClient;
    protected final SQLContext sqlContext;
    protected final SparkBigQueryConfig config;
    protected final Optional<TableInfo> table;

    protected BigQueryInsertableRelationBase(BigQueryClient bigQueryClient, SQLContext sqlContext, SparkBigQueryConfig config) {
        this.bigQueryClient = bigQueryClient;
        this.sqlContext = sqlContext;
        this.config = config;
        this.table = Optional.ofNullable(bigQueryClient.getTable(config.getTableId()));
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        return SchemaConverters.from(SchemaConvertersConfiguration.from(this.config)).toSpark(((TableDefinition)this.table.get().getDefinition()).getSchema());
    }

    public boolean exists() {
        return this.table.isPresent();
    }

    public boolean isEmpty() {
        return this.numberOfRows().map(n -> n.longValue() == 0L).orElse(true);
    }

    private Optional<BigInteger> numberOfRows() {
        return this.table.map(TableInfo::getNumRows);
    }

    public TableId getTableId() {
        return this.config.getTableId();
    }
}

