/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.write.context;

import com.google.cloud.bigquery.connector.common.BigQueryClient;
import com.google.cloud.bigquery.connector.common.BigQueryUtil;
import com.google.cloud.spark.bigquery.DataSourceVersion;
import com.google.cloud.spark.bigquery.SparkBigQueryConfig;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.JobInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableInfo;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.com.google.inject.Injector;
import com.google.cloud.spark.bigquery.write.context.BigQueryDataSourceWriterModule;
import com.google.cloud.spark.bigquery.write.context.BigQueryDirectDataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.BigQueryIndirectDataSourceWriterContext;
import com.google.cloud.spark.bigquery.write.context.DataWriterContextFactory;
import com.google.cloud.spark.bigquery.write.context.WriterCommitMessageContext;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;

public interface DataSourceWriterContext {
    public DataWriterContextFactory<InternalRow> createWriterContextFactory();

    default public boolean useCommitCoordinator() {
        return true;
    }

    default public void onDataWriterCommit(WriterCommitMessageContext message) {
    }

    default public void onDataStreamingWriterCommit(long epochId, WriterCommitMessageContext[] messages) {
    }

    default public void onDataStreamingWriterAbort(long epochId, WriterCommitMessageContext[] messages) {
    }

    public void commit(WriterCommitMessageContext[] var1);

    public void abort(WriterCommitMessageContext[] var1);

    public void setTableInfo(TableInfo var1);

    public static Optional<DataSourceWriterContext> create(Injector injector, String writeUUID, StructType schema, SaveMode mode, Map<String, String> options) {
        TableId tableId;
        Injector writerInjector;
        BigQueryClient bigQueryClient;
        TableInfo table;
        SparkBigQueryConfig tableConfig = injector.getInstance(SparkBigQueryConfig.class);
        if (tableConfig.getTableId() == null) {
            SparkSession spark = injector.getInstance(SparkSession.class);
            tableConfig = SparkBigQueryConfig.from(options, ImmutableMap.of(), DataSourceVersion.V2, spark, Optional.of(schema), true);
        }
        if ((table = (bigQueryClient = (writerInjector = injector.createChildInjector(new BigQueryDataSourceWriterModule(tableConfig, writeUUID, schema, mode))).getInstance(BigQueryClient.class)).getTable(tableId = tableConfig.getTableId())) != null) {
            if (mode == SaveMode.Ignore) {
                return Optional.empty();
            }
            if (mode == SaveMode.ErrorIfExists) {
                throw new IllegalArgumentException(String.format("SaveMode is set to ErrorIfExists and table '%s' already exists. Did you want to add data to the table by setting the SaveMode to Append? Example: df.write.format.options.mode(\"append\").save()", BigQueryUtil.friendlyTableName(table.getTableId())));
            }
        } else {
            boolean createNever = tableConfig.getCreateDisposition().map(createDisposition -> createDisposition == JobInfo.CreateDisposition.CREATE_NEVER).orElse(false);
            if (createNever) {
                throw new IllegalArgumentException(String.format("For table %s Create Disposition is CREATE_NEVER and the table does not exists. Aborting the insert", BigQueryUtil.friendlyTableName(tableId)));
            }
        }
        DataSourceWriterContext dataSourceWriterContext = null;
        switch (tableConfig.getWriteMethod()) {
            case DIRECT: {
                dataSourceWriterContext = writerInjector.getInstance(BigQueryDirectDataSourceWriterContext.class);
                break;
            }
            case INDIRECT: {
                dataSourceWriterContext = writerInjector.getInstance(BigQueryIndirectDataSourceWriterContext.class);
            }
        }
        dataSourceWriterContext.setTableInfo(table);
        return Optional.of(dataSourceWriterContext);
    }
}

