/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.jsontype.impl;

import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.core.JsonParser;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.core.JsonToken;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.core.util.JsonParserSequence;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.BeanProperty;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.DeserializationContext;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.DeserializationFeature;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.JavaType;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.MapperFeature;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.jsontype.impl.AsArrayTypeDeserializer;
import com.google.cloud.spark.bigquery.repackaged.com.fasterxml.jackson.databind.util.TokenBuffer;
import java.io.IOException;

public class AsPropertyTypeDeserializer
extends AsArrayTypeDeserializer {
    private static final long serialVersionUID = 1L;
    protected final JsonTypeInfo.As _inclusion;
    protected final boolean _strictTypeIdHandling;
    protected final String _msgForMissingId;

    @Deprecated
    public AsPropertyTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl) {
        this(bt, idRes, typePropertyName, typeIdVisible, defaultImpl, JsonTypeInfo.As.PROPERTY);
    }

    @Deprecated
    public AsPropertyTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl, JsonTypeInfo.As inclusion) {
        this(bt, idRes, typePropertyName, typeIdVisible, defaultImpl, inclusion, true);
    }

    public AsPropertyTypeDeserializer(AsPropertyTypeDeserializer src, BeanProperty property) {
        super(src, property);
        this._msgForMissingId = this._property == null ? String.format("missing type id property '%s'", this._typePropertyName) : String.format("missing type id property '%s' (for POJO property '%s')", this._typePropertyName, this._property.getName());
        this._inclusion = src._inclusion;
        this._strictTypeIdHandling = src._strictTypeIdHandling;
    }

    public AsPropertyTypeDeserializer(JavaType bt, TypeIdResolver idRes, String typePropertyName, boolean typeIdVisible, JavaType defaultImpl, JsonTypeInfo.As inclusion, boolean strictTypeIdHandling) {
        super(bt, idRes, typePropertyName, typeIdVisible, defaultImpl);
        this._msgForMissingId = this._property == null ? String.format("missing type id property '%s'", this._typePropertyName) : String.format("missing type id property '%s' (for POJO property '%s')", this._typePropertyName, this._property.getName());
        this._inclusion = inclusion;
        this._strictTypeIdHandling = strictTypeIdHandling;
    }

    @Override
    public TypeDeserializer forProperty(BeanProperty prop) {
        return prop == this._property ? this : new AsPropertyTypeDeserializer(this, prop);
    }

    @Override
    public JsonTypeInfo.As getTypeInclusion() {
        return this._inclusion;
    }

    @Override
    public Object deserializeTypedFromObject(JsonParser p, DeserializationContext ctxt) throws IOException {
        Object typeId;
        if (p.canReadTypeId() && (typeId = p.getTypeId()) != null) {
            return this._deserializeWithNativeTypeId(p, ctxt, typeId);
        }
        JsonToken t2 = p.currentToken();
        if (t2 == JsonToken.START_OBJECT) {
            t2 = p.nextToken();
        } else if (t2 != JsonToken.FIELD_NAME) {
            return this._deserializeTypedUsingDefaultImpl(p, ctxt, null, this._msgForMissingId);
        }
        TokenBuffer tb = null;
        boolean ignoreCase = ctxt.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES);
        while (t2 == JsonToken.FIELD_NAME) {
            String typeId2;
            String name = p.currentName();
            p.nextToken();
            if ((name.equals(this._typePropertyName) || ignoreCase && name.equalsIgnoreCase(this._typePropertyName)) && (typeId2 = p.getValueAsString()) != null) {
                return this._deserializeTypedForId(p, ctxt, tb, typeId2);
            }
            if (tb == null) {
                tb = ctxt.bufferForInputBuffering(p);
            }
            tb.writeFieldName(name);
            tb.copyCurrentStructure(p);
            t2 = p.nextToken();
        }
        return this._deserializeTypedUsingDefaultImpl(p, ctxt, tb, this._msgForMissingId);
    }

    protected Object _deserializeTypedForId(JsonParser p, DeserializationContext ctxt, TokenBuffer tb, String typeId) throws IOException {
        JsonDeserializer<Object> deser = this._findDeserializer(ctxt, typeId);
        if (this._typeIdVisible) {
            if (tb == null) {
                tb = ctxt.bufferForInputBuffering(p);
            }
            tb.writeFieldName(p.currentName());
            tb.writeString(typeId);
        }
        if (tb != null) {
            p.clearCurrentToken();
            p = JsonParserSequence.createFlattened(false, tb.asParser(p), p);
        }
        if (p.currentToken() != JsonToken.END_OBJECT) {
            p.nextToken();
        }
        return deser.deserialize(p, ctxt);
    }

    @Deprecated
    protected Object _deserializeTypedUsingDefaultImpl(JsonParser p, DeserializationContext ctxt, TokenBuffer tb) throws IOException {
        return this._deserializeTypedUsingDefaultImpl(p, ctxt, tb, null);
    }

    protected Object _deserializeTypedUsingDefaultImpl(JsonParser p, DeserializationContext ctxt, TokenBuffer tb, String priorFailureMsg) throws IOException {
        JsonDeserializer<Object> deser;
        if (!this.hasDefaultImpl()) {
            String str;
            Object result = TypeDeserializer.deserializeIfNatural(p, ctxt, this._baseType);
            if (result != null) {
                return result;
            }
            if (p.isExpectedStartArrayToken()) {
                return super.deserializeTypedFromAny(p, ctxt);
            }
            if (p.hasToken(JsonToken.VALUE_STRING) && ctxt.isEnabled(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT) && (str = p.getText().trim()).isEmpty()) {
                return null;
            }
        }
        if ((deser = this._findDefaultImplDeserializer(ctxt)) == null) {
            JavaType t2;
            JavaType javaType = t2 = this._strictTypeIdHandling ? this._handleMissingTypeId(ctxt, priorFailureMsg) : this._baseType;
            if (t2 == null) {
                return null;
            }
            deser = ctxt.findContextualValueDeserializer(t2, this._property);
        }
        if (tb != null) {
            tb.writeEndObject();
            p = tb.asParser(p);
            p.nextToken();
        }
        return deser.deserialize(p, ctxt);
    }

    @Override
    public Object deserializeTypedFromAny(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.START_ARRAY)) {
            return super.deserializeTypedFromArray(p, ctxt);
        }
        return this.deserializeTypedFromObject(p, ctxt);
    }
}

