/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeTokenRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.CredentialRefreshListener;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.CredentialStore;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.CredentialStoreRefreshListener;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.DataStoreCredentialRefreshListener;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.StoredCredential;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.GenericUrl;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpExecuteInterceptor;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequest;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpRequestInitializer;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.HttpTransport;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.http.UrlEncodedContent;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.json.JsonFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Base64;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Beta;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Clock;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Data;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Joiner;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Lists;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.Strings;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.store.DataStore;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.client.util.store.DataStoreFactory;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class AuthorizationCodeFlow {
    private final Credential.AccessMethod method;
    private final HttpTransport transport;
    private final JsonFactory jsonFactory;
    private final String tokenServerEncodedUrl;
    private final HttpExecuteInterceptor clientAuthentication;
    private final String clientId;
    private final String authorizationServerEncodedUrl;
    private final PKCE pkce;
    @Deprecated
    @Beta
    private final CredentialStore credentialStore;
    @Beta
    private final DataStore<StoredCredential> credentialDataStore;
    private final HttpRequestInitializer requestInitializer;
    private final Clock clock;
    private final Collection<String> scopes;
    private final CredentialCreatedListener credentialCreatedListener;
    private final Collection<CredentialRefreshListener> refreshListeners;

    public AuthorizationCodeFlow(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl) {
        this(new Builder(method, transport, jsonFactory, tokenServerUrl, clientAuthentication, clientId, authorizationServerEncodedUrl));
    }

    protected AuthorizationCodeFlow(Builder builder) {
        this.method = Preconditions.checkNotNull(builder.method);
        this.transport = Preconditions.checkNotNull(builder.transport);
        this.jsonFactory = Preconditions.checkNotNull(builder.jsonFactory);
        this.tokenServerEncodedUrl = Preconditions.checkNotNull(builder.tokenServerUrl).build();
        this.clientAuthentication = builder.clientAuthentication;
        this.clientId = Preconditions.checkNotNull(builder.clientId);
        this.authorizationServerEncodedUrl = Preconditions.checkNotNull(builder.authorizationServerEncodedUrl);
        this.requestInitializer = builder.requestInitializer;
        this.credentialStore = builder.credentialStore;
        this.credentialDataStore = builder.credentialDataStore;
        this.scopes = Collections.unmodifiableCollection(builder.scopes);
        this.clock = Preconditions.checkNotNull(builder.clock);
        this.credentialCreatedListener = builder.credentialCreatedListener;
        this.refreshListeners = Collections.unmodifiableCollection(builder.refreshListeners);
        this.pkce = builder.pkce;
    }

    public AuthorizationCodeRequestUrl newAuthorizationUrl() {
        AuthorizationCodeRequestUrl url = new AuthorizationCodeRequestUrl(this.authorizationServerEncodedUrl, this.clientId);
        url.setScopes((Collection)this.scopes);
        if (this.pkce != null) {
            url.setCodeChallenge(this.pkce.getChallenge());
            url.setCodeChallengeMethod(this.pkce.getChallengeMethod());
        }
        return url;
    }

    public AuthorizationCodeTokenRequest newTokenRequest(String authorizationCode) {
        HttpExecuteInterceptor pkceClientAuthenticationWrapper = new HttpExecuteInterceptor(){

            @Override
            public void intercept(HttpRequest request) throws IOException {
                AuthorizationCodeFlow.this.clientAuthentication.intercept(request);
                if (AuthorizationCodeFlow.this.pkce != null) {
                    Map<String, Object> data = Data.mapOf(UrlEncodedContent.getContent(request).getData());
                    data.put("code_verifier", AuthorizationCodeFlow.this.pkce.getVerifier());
                }
            }
        };
        return new AuthorizationCodeTokenRequest(this.transport, this.jsonFactory, new GenericUrl(this.tokenServerEncodedUrl), authorizationCode).setClientAuthentication(pkceClientAuthenticationWrapper).setRequestInitializer(this.requestInitializer).setScopes((Collection)this.scopes);
    }

    public Credential createAndStoreCredential(TokenResponse response, String userId) throws IOException {
        Credential credential = this.newCredential(userId).setFromTokenResponse(response);
        if (this.credentialStore != null) {
            this.credentialStore.store(userId, credential);
        }
        if (this.credentialDataStore != null) {
            this.credentialDataStore.set(userId, new StoredCredential(credential));
        }
        if (this.credentialCreatedListener != null) {
            this.credentialCreatedListener.onCredentialCreated(credential, response);
        }
        return credential;
    }

    public Credential loadCredential(String userId) throws IOException {
        if (Strings.isNullOrEmpty(userId)) {
            return null;
        }
        if (this.credentialDataStore == null && this.credentialStore == null) {
            return null;
        }
        Credential credential = this.newCredential(userId);
        if (this.credentialDataStore != null) {
            StoredCredential stored = this.credentialDataStore.get(userId);
            if (stored == null) {
                return null;
            }
            credential.setAccessToken(stored.getAccessToken());
            credential.setRefreshToken(stored.getRefreshToken());
            credential.setExpirationTimeMilliseconds(stored.getExpirationTimeMilliseconds());
        } else if (!this.credentialStore.load(userId, credential)) {
            return null;
        }
        return credential;
    }

    private Credential newCredential(String userId) {
        Credential.Builder builder = new Credential.Builder(this.method).setTransport(this.transport).setJsonFactory(this.jsonFactory).setTokenServerEncodedUrl(this.tokenServerEncodedUrl).setClientAuthentication(this.clientAuthentication).setRequestInitializer(this.requestInitializer).setClock(this.clock);
        if (this.credentialDataStore != null) {
            builder.addRefreshListener(new DataStoreCredentialRefreshListener(userId, this.credentialDataStore));
        } else if (this.credentialStore != null) {
            builder.addRefreshListener(new CredentialStoreRefreshListener(userId, this.credentialStore));
        }
        builder.getRefreshListeners().addAll(this.refreshListeners);
        return builder.build();
    }

    public final Credential.AccessMethod getMethod() {
        return this.method;
    }

    public final HttpTransport getTransport() {
        return this.transport;
    }

    public final JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public final String getTokenServerEncodedUrl() {
        return this.tokenServerEncodedUrl;
    }

    public final HttpExecuteInterceptor getClientAuthentication() {
        return this.clientAuthentication;
    }

    public final String getClientId() {
        return this.clientId;
    }

    public final String getAuthorizationServerEncodedUrl() {
        return this.authorizationServerEncodedUrl;
    }

    @Deprecated
    @Beta
    public final CredentialStore getCredentialStore() {
        return this.credentialStore;
    }

    @Beta
    public final DataStore<StoredCredential> getCredentialDataStore() {
        return this.credentialDataStore;
    }

    public final HttpRequestInitializer getRequestInitializer() {
        return this.requestInitializer;
    }

    public final String getScopesAsString() {
        return Joiner.on(' ').join(this.scopes);
    }

    public final Collection<String> getScopes() {
        return this.scopes;
    }

    public final Clock getClock() {
        return this.clock;
    }

    public final Collection<CredentialRefreshListener> getRefreshListeners() {
        return this.refreshListeners;
    }

    public static class Builder {
        Credential.AccessMethod method;
        HttpTransport transport;
        JsonFactory jsonFactory;
        GenericUrl tokenServerUrl;
        HttpExecuteInterceptor clientAuthentication;
        String clientId;
        String authorizationServerEncodedUrl;
        PKCE pkce;
        @Deprecated
        @Beta
        CredentialStore credentialStore;
        @Beta
        DataStore<StoredCredential> credentialDataStore;
        HttpRequestInitializer requestInitializer;
        Collection<String> scopes = Lists.newArrayList();
        Clock clock = Clock.SYSTEM;
        CredentialCreatedListener credentialCreatedListener;
        Collection<CredentialRefreshListener> refreshListeners = Lists.newArrayList();

        public Builder(Credential.AccessMethod method, HttpTransport transport, JsonFactory jsonFactory, GenericUrl tokenServerUrl, HttpExecuteInterceptor clientAuthentication, String clientId, String authorizationServerEncodedUrl) {
            this.setMethod(method);
            this.setTransport(transport);
            this.setJsonFactory(jsonFactory);
            this.setTokenServerUrl(tokenServerUrl);
            this.setClientAuthentication(clientAuthentication);
            this.setClientId(clientId);
            this.setAuthorizationServerEncodedUrl(authorizationServerEncodedUrl);
        }

        public AuthorizationCodeFlow build() {
            return new AuthorizationCodeFlow(this);
        }

        public final Credential.AccessMethod getMethod() {
            return this.method;
        }

        public Builder setMethod(Credential.AccessMethod method) {
            this.method = Preconditions.checkNotNull(method);
            return this;
        }

        public final HttpTransport getTransport() {
            return this.transport;
        }

        public Builder setTransport(HttpTransport transport) {
            this.transport = Preconditions.checkNotNull(transport);
            return this;
        }

        public final JsonFactory getJsonFactory() {
            return this.jsonFactory;
        }

        public Builder setJsonFactory(JsonFactory jsonFactory) {
            this.jsonFactory = Preconditions.checkNotNull(jsonFactory);
            return this;
        }

        public final GenericUrl getTokenServerUrl() {
            return this.tokenServerUrl;
        }

        public Builder setTokenServerUrl(GenericUrl tokenServerUrl) {
            this.tokenServerUrl = Preconditions.checkNotNull(tokenServerUrl);
            return this;
        }

        public final HttpExecuteInterceptor getClientAuthentication() {
            return this.clientAuthentication;
        }

        public Builder setClientAuthentication(HttpExecuteInterceptor clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final String getClientId() {
            return this.clientId;
        }

        public Builder setClientId(String clientId) {
            this.clientId = Preconditions.checkNotNull(clientId);
            return this;
        }

        public final String getAuthorizationServerEncodedUrl() {
            return this.authorizationServerEncodedUrl;
        }

        public Builder setAuthorizationServerEncodedUrl(String authorizationServerEncodedUrl) {
            this.authorizationServerEncodedUrl = Preconditions.checkNotNull(authorizationServerEncodedUrl);
            return this;
        }

        @Deprecated
        @Beta
        public final CredentialStore getCredentialStore() {
            return this.credentialStore;
        }

        @Beta
        public final DataStore<StoredCredential> getCredentialDataStore() {
            return this.credentialDataStore;
        }

        public final Clock getClock() {
            return this.clock;
        }

        public Builder setClock(Clock clock) {
            this.clock = Preconditions.checkNotNull(clock);
            return this;
        }

        @Deprecated
        @Beta
        public Builder setCredentialStore(CredentialStore credentialStore) {
            Preconditions.checkArgument(this.credentialDataStore == null);
            this.credentialStore = credentialStore;
            return this;
        }

        @Beta
        public Builder setDataStoreFactory(DataStoreFactory dataStoreFactory) throws IOException {
            return this.setCredentialDataStore(StoredCredential.getDefaultDataStore(dataStoreFactory));
        }

        @Beta
        public Builder setCredentialDataStore(DataStore<StoredCredential> credentialDataStore) {
            Preconditions.checkArgument(this.credentialStore == null);
            this.credentialDataStore = credentialDataStore;
            return this;
        }

        public final HttpRequestInitializer getRequestInitializer() {
            return this.requestInitializer;
        }

        public Builder setRequestInitializer(HttpRequestInitializer requestInitializer) {
            this.requestInitializer = requestInitializer;
            return this;
        }

        @Beta
        public Builder enablePKCE() {
            this.pkce = new PKCE();
            return this;
        }

        public Builder setScopes(Collection<String> scopes) {
            this.scopes = Preconditions.checkNotNull(scopes);
            return this;
        }

        public final Collection<String> getScopes() {
            return this.scopes;
        }

        public Builder setCredentialCreatedListener(CredentialCreatedListener credentialCreatedListener) {
            this.credentialCreatedListener = credentialCreatedListener;
            return this;
        }

        public Builder addRefreshListener(CredentialRefreshListener refreshListener) {
            this.refreshListeners.add(Preconditions.checkNotNull(refreshListener));
            return this;
        }

        public final Collection<CredentialRefreshListener> getRefreshListeners() {
            return this.refreshListeners;
        }

        public Builder setRefreshListeners(Collection<CredentialRefreshListener> refreshListeners) {
            this.refreshListeners = Preconditions.checkNotNull(refreshListeners);
            return this;
        }

        public final CredentialCreatedListener getCredentialCreatedListener() {
            return this.credentialCreatedListener;
        }
    }

    private static class PKCE {
        private final String verifier = PKCE.generateVerifier();
        private String challenge;
        private String challengeMethod;

        public PKCE() {
            this.generateChallenge(this.verifier);
        }

        private static String generateVerifier() {
            SecureRandom sr = new SecureRandom();
            byte[] code = new byte[32];
            sr.nextBytes(code);
            return Base64.encodeBase64URLSafeString(code);
        }

        private void generateChallenge(String verifier) {
            try {
                byte[] bytes = verifier.getBytes();
                MessageDigest md = MessageDigest.getInstance("SHA-256");
                md.update(bytes, 0, bytes.length);
                byte[] digest = md.digest();
                this.challenge = Base64.encodeBase64URLSafeString(digest);
                this.challengeMethod = "S256";
            }
            catch (NoSuchAlgorithmException e) {
                this.challenge = verifier;
                this.challengeMethod = "plain";
            }
        }

        public String getVerifier() {
            return this.verifier;
        }

        public String getChallenge() {
            return this.challenge;
        }

        public String getChallengeMethod() {
            return this.challengeMethod;
        }
    }

    public static interface CredentialCreatedListener {
        public void onCredentialCreated(Credential var1, TokenResponse var2) throws IOException;
    }
}

