/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.TagField;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonParser;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.DeserializationContext;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.JsonDeserializer;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.JsonNode;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class TagsDeserializer
extends JsonDeserializer<List<TagField>> {
    private String preprocessEscapes(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\\' && !escaped) {
                escaped = true;
                continue;
            }
            if (escaped) {
                if (c == ':' || c == ';') {
                    result.append((char)(c == ':' ? 1 : 2));
                } else {
                    result.append('\\').append(c);
                }
                escaped = false;
                continue;
            }
            result.append(c);
        }
        if (escaped) {
            result.append('\\');
        }
        return result.toString();
    }

    private String restoreEscapes(String input) {
        return input.replace('\u0001', ':').replace('\u0002', ';');
    }

    @Override
    public List<TagField> deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        Stream<String> tagText;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        if (node.isArray()) {
            tagText = StreamSupport.stream(node.spliterator(), false).map(JsonNode::asText).filter(StringUtils::isNotBlank).map(this::preprocessEscapes);
        } else if (node.isTextual()) {
            tagText = Arrays.stream(this.preprocessEscapes(node.asText()).split(";")).filter(StringUtils::isNotBlank);
        } else {
            return Collections.emptyList();
        }
        return tagText.filter(StringUtils::isNotBlank).flatMap(x -> {
            String[] elements = x.split(":");
            String value = "true";
            String source = "CONFIG";
            if (elements.length == 0) {
                return Stream.empty();
            }
            if (StringUtils.isBlank((CharSequence)elements[0])) {
                return Stream.empty();
            }
            String key = this.restoreEscapes(elements[0]).trim();
            if (elements.length >= 2) {
                if (StringUtils.isBlank((CharSequence)elements[1])) {
                    return Stream.empty();
                }
                value = this.restoreEscapes(elements[1]).trim();
            }
            if (elements.length >= 3) {
                if (StringUtils.isBlank((CharSequence)elements[2])) {
                    return Stream.empty();
                }
                source = this.restoreEscapes(elements[2]).trim();
            }
            return Stream.of(new TagField(key, value, source));
        }).collect(Collectors.toList());
    }
}

