/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.filesystem;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.DatasetIdentifier;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.filesystem.FilesystemDatasetExtractor;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.filesystem.FilesystemUriSanitizer;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.lang3.StringUtils;
import java.net.URI;
import java.util.Optional;

public class GenericFilesystemDatasetExtractor
implements FilesystemDatasetExtractor {
    @Override
    public boolean isDefinedAt(URI location) {
        return true;
    }

    @Override
    public DatasetIdentifier extract(URI location) {
        URI namespace = new URI(location.getScheme(), location.getAuthority(), "/", null, null);
        String name = location.getPath();
        return this.extract(namespace, name);
    }

    @Override
    public DatasetIdentifier extract(URI location, String rawName) {
        String namespace = Optional.of(location.toString()).map(FilesystemUriSanitizer::removeLastSlash).map(scheme -> StringUtils.stripEnd((String)scheme, (String)":")).get();
        String name = Optional.of(rawName).map(FilesystemUriSanitizer::removeLastSlash).map(FilesystemUriSanitizer::nonEmptyPath).get();
        return new DatasetIdentifier(name, namespace);
    }
}

