/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.ArrowBuf;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.BufferAllocator;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.OutOfMemoryException;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.ByteFunctionHelpers;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.CommonUtil;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.LargeMemoryUtil;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.AddOrGetResult;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BaseValueVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BitVectorHelper;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BufferBacked;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.FieldVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ValueIterableVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ValueVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ZeroVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compare.VectorVisitor;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.BaseListVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.PromotableVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.UnionVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.impl.UnionFixedSizeListReader;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.impl.UnionFixedSizeListWriter;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.reader.FieldReader;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.Types;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.ArrowType;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.Field;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.FieldType;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.CallBack;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.JsonStringArrayList;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.OversizedAllocationException;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.SchemaChangeRuntimeException;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.TransferPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class FixedSizeListVector
extends BaseValueVector
implements BaseListVector,
PromotableVector,
ValueIterableVector<List<?>> {
    private FieldVector vector;
    private ArrowBuf validityBuffer;
    private final int listSize;
    private Field field;
    private UnionFixedSizeListReader reader;
    private int valueCount;
    private int validityAllocationSizeInBytes;

    public static FixedSizeListVector empty(String name, int size, BufferAllocator allocator) {
        FieldType fieldType = FieldType.nullable(new ArrowType.FixedSizeList(size));
        return new FixedSizeListVector(name, allocator, fieldType, null);
    }

    public FixedSizeListVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack unusedSchemaChangeCallback) {
        this(new Field(name, fieldType, null), allocator, unusedSchemaChangeCallback);
    }

    public FixedSizeListVector(Field field, BufferAllocator allocator, CallBack unusedSchemaChangeCallback) {
        super(allocator);
        this.field = field;
        this.validityBuffer = allocator.getEmpty();
        this.vector = ZeroVector.INSTANCE;
        this.listSize = ((ArrowType.FixedSizeList)field.getFieldType().getType()).getListSize();
        Preconditions.checkArgument(this.listSize >= 0, "list size must be non-negative");
        this.valueCount = 0;
        this.validityAllocationSizeInBytes = FixedSizeListVector.getValidityBufferSizeFromCount(3970);
    }

    @Override
    public Field getField() {
        if (this.field.getChildren().contains(this.getDataVector().getField())) {
            return this.field;
        }
        this.field = new Field(this.field.getName(), this.field.getFieldType(), Collections.singletonList(this.getDataVector().getField()));
        return this.field;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.FIXED_SIZE_LIST;
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    public int getListSize() {
        return this.listSize;
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        Preconditions.checkArgument(children.size() == 1, "Lists have one child Field. Found: %s", children.isEmpty() ? "none" : children);
        Field field = children.get(0);
        AddOrGetResult addOrGetVector = this.addOrGetVector(field.getFieldType());
        Preconditions.checkArgument(addOrGetVector.isCreated(), "Child vector already existed: %s", addOrGetVector.getVector());
        ((FieldVector)addOrGetVector.getVector()).initializeChildrenFromFields(field.getChildren());
        this.field = new Field(this.field.getName(), this.field.getFieldType(), children);
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Collections.singletonList(this.vector);
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (ownBuffers.size() != 1) {
            throw new IllegalArgumentException("Illegal buffer count, expected 1, got: " + ownBuffers.size());
        }
        ArrowBuf bitBuffer = ownBuffers.get(0);
        this.validityBuffer.getReferenceManager().release();
        this.validityBuffer = BitVectorHelper.loadValidityBuffer(fieldNode, bitBuffer, this.allocator);
        this.valueCount = fieldNode.getLength();
        this.validityAllocationSizeInBytes = LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity());
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        ArrayList<ArrowBuf> result = new ArrayList<ArrowBuf>(1);
        this.setReaderAndWriterIndex();
        result.add(this.validityBuffer);
        return result;
    }

    private void setReaderAndWriterIndex() {
        this.validityBuffer.readerIndex(0L);
        this.validityBuffer.writerIndex(FixedSizeListVector.getValidityBufferSizeFromCount(this.valueCount));
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers");
    }

    @Override
    protected FieldReader getReaderImpl() {
        return new UnionFixedSizeListReader(this);
    }

    @Override
    public UnionFixedSizeListReader getReader() {
        this.reader = (UnionFixedSizeListReader)super.getReader();
        return this.reader;
    }

    private void invalidateReader() {
        this.reader = null;
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        boolean success = false;
        try {
            this.clear();
            this.allocateValidityBuffer(this.validityAllocationSizeInBytes);
            success = this.vector.allocateNewSafe();
        }
        finally {
            if (!success) {
                this.clear();
            }
        }
        return success;
    }

    private void allocateValidityBuffer(long size) {
        int curSize = (int)size;
        this.validityBuffer = this.allocator.buffer(curSize);
        this.validityBuffer.readerIndex(0L);
        this.validityAllocationSizeInBytes = curSize;
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
    }

    @Override
    public void reAlloc() {
        this.reallocValidityBuffer();
        this.vector.reAlloc();
    }

    private void reallocValidityBuffer() {
        int currentBufferCapacity = LargeMemoryUtil.checkedCastToInt(this.validityBuffer.capacity());
        long newAllocationSize = (long)currentBufferCapacity * 2L;
        if (newAllocationSize == 0L) {
            newAllocationSize = this.validityAllocationSizeInBytes > 0 ? (long)this.validityAllocationSizeInBytes : (long)FixedSizeListVector.getValidityBufferSizeFromCount(3970) * 2L;
        }
        newAllocationSize = CommonUtil.nextPowerOfTwo(newAllocationSize);
        assert (newAllocationSize >= 1L);
        if (newAllocationSize > MAX_ALLOCATION_SIZE) {
            throw new OversizedAllocationException("Unable to expand the buffer");
        }
        ArrowBuf newBuf = this.allocator.buffer(newAllocationSize);
        newBuf.setBytes(0L, this.validityBuffer, 0L, (long)currentBufferCapacity);
        newBuf.setZero(currentBufferCapacity, newBuf.capacity() - (long)currentBufferCapacity);
        this.validityBuffer.getReferenceManager().release(1);
        this.validityBuffer = newBuf;
        this.validityAllocationSizeInBytes = (int)newAllocationSize;
    }

    public FieldVector getDataVector() {
        return this.vector;
    }

    public int startNewValue(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
        return index * this.listSize;
    }

    public UnionFixedSizeListWriter getWriter() {
        return new UnionFixedSizeListWriter(this);
    }

    @Override
    public void setInitialCapacity(int numRecords) {
        this.validityAllocationSizeInBytes = FixedSizeListVector.getValidityBufferSizeFromCount(numRecords);
        this.vector.setInitialCapacity(numRecords * this.listSize);
    }

    @Override
    public int getValueCapacity() {
        if (this.vector == ZeroVector.INSTANCE || this.listSize == 0) {
            return 0;
        }
        return Math.min(this.vector.getValueCapacity() / this.listSize, this.getValidityBufferValueCapacity());
    }

    @Override
    public int getBufferSize() {
        if (this.getValueCount() == 0) {
            return 0;
        }
        return FixedSizeListVector.getValidityBufferSizeFromCount(this.valueCount) + this.vector.getBufferSize();
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        if (valueCount == 0) {
            return 0;
        }
        return FixedSizeListVector.getValidityBufferSizeFromCount(valueCount) + this.vector.getBufferSizeFor(valueCount * this.listSize);
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.singleton(this.vector).iterator();
    }

    @Override
    public void clear() {
        this.validityBuffer = this.releaseBuffer(this.validityBuffer);
        this.vector.clear();
        this.valueCount = 0;
        super.clear();
    }

    @Override
    public void reset() {
        this.validityBuffer.setZero(0L, this.validityBuffer.capacity());
        this.vector.reset();
        this.valueCount = 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        ArrowBuf[] buffers;
        this.setReaderAndWriterIndex();
        if (this.getBufferSize() == 0) {
            buffers = new ArrowBuf[]{};
        } else {
            ArrayList<ArrowBuf> list = new ArrayList<ArrowBuf>();
            list.add(this.validityBuffer);
            list.addAll(Arrays.asList(this.vector.getBuffers(false)));
            buffers = list.toArray(new ArrowBuf[list.size()]);
        }
        if (clear) {
            for (ArrowBuf buffer : buffers) {
                buffer.getReferenceManager().retain();
            }
            this.clear();
        }
        return buffers;
    }

    public int size() {
        return this.vector == ZeroVector.INSTANCE ? 0 : 1;
    }

    @Override
    public <T extends ValueVector> AddOrGetResult<T> addOrGetVector(FieldType type) {
        boolean created = false;
        if (this.vector == ZeroVector.INSTANCE) {
            this.vector = type.createNewSingleVector("$data$", this.allocator, null);
            this.invalidateReader();
            created = true;
        }
        if (!Objects.equals(this.vector.getField().getType(), type.getType())) {
            String msg = String.format("Inner vector type mismatch. Requested type: [%s], actual type: [%s]", type.getType(), this.vector.getField().getType());
            throw new SchemaChangeRuntimeException(msg);
        }
        return new AddOrGetResult<FieldVector>(this.vector, created);
    }

    @Override
    public void copyFromSafe(int inIndex, int outIndex, ValueVector from) {
        this.copyFrom(inIndex, outIndex, from);
    }

    @Override
    public void copyFrom(int fromIndex, int thisIndex, ValueVector from) {
        Preconditions.checkArgument(this.getMinorType() == from.getMinorType());
        TransferPair pair = from.makeTransferPair(this);
        pair.copyValueSafe(fromIndex, thisIndex);
    }

    @Override
    public UnionVector promoteToUnion() {
        UnionVector vector = new UnionVector(this.getName(), this.allocator, null, null);
        this.vector.clear();
        this.vector = vector;
        this.invalidateReader();
        return vector;
    }

    @Override
    public long getValidityBufferAddress() {
        return this.validityBuffer.memoryAddress();
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        return this.validityBuffer;
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<?> getObject(int index) {
        if (this.isSet(index) == 0) {
            return null;
        }
        JsonStringArrayList<Object> vals = new JsonStringArrayList<Object>(this.listSize);
        for (int i = 0; i < this.listSize; ++i) {
            vals.add(this.vector.getObject(index * this.listSize + i));
        }
        return vals;
    }

    @Override
    public boolean isNull(int index) {
        return this.isSet(index) == 0;
    }

    public int isSet(int index) {
        int byteIndex = index >> 3;
        byte b = this.validityBuffer.getByte(byteIndex);
        int bitIndex = index & 7;
        return b >> bitIndex & 1;
    }

    @Override
    public int getNullCount() {
        return BitVectorHelper.getNullCount(this.validityBuffer, this.valueCount);
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    private int getValidityBufferValueCapacity() {
        return LargeMemoryUtil.capAtMaxInt(this.validityBuffer.capacity() * 8L);
    }

    @Override
    public void setNull(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.unsetBit(this.validityBuffer, index);
    }

    public void setNotNull(int index) {
        while (index >= this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        BitVectorHelper.setBit(this.validityBuffer, index);
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
        while (valueCount > this.getValidityBufferValueCapacity()) {
            this.reallocValidityBuffer();
        }
        this.vector.setValueCount(valueCount * this.listSize);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return this.getTransferPair(field, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(ref, allocator, callBack);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(field, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((FixedSizeListVector)target);
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        if (this.isSet(index) == 0) {
            return 0;
        }
        int hash = 0;
        for (int i = 0; i < this.listSize; ++i) {
            hash = ByteFunctionHelpers.combineHash(hash, this.vector.hashCode(index * this.listSize + i, hasher));
        }
        return hash;
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    public int getElementStartIndex(int index) {
        return this.listSize * index;
    }

    @Override
    public int getElementEndIndex(int index) {
        return this.listSize * (index + 1);
    }

    private class TransferImpl
    implements TransferPair {
        FixedSizeListVector to;
        TransferPair dataPair;

        public TransferImpl(String name, BufferAllocator allocator, CallBack callBack) {
            this(new FixedSizeListVector(name, allocator, fixedSizeListVector.field.getFieldType(), callBack));
        }

        public TransferImpl(Field field, BufferAllocator allocator, CallBack callBack) {
            this(new FixedSizeListVector(field, allocator, callBack));
        }

        public TransferImpl(FixedSizeListVector to) {
            this.to = to;
            if (!(FixedSizeListVector.this.vector instanceof ZeroVector)) {
                to.addOrGetVector(FixedSizeListVector.this.vector.getField().getFieldType());
            }
            this.dataPair = FixedSizeListVector.this.vector.makeTransferPair(to.vector);
        }

        @Override
        public void transfer() {
            this.to.clear();
            this.dataPair.transfer();
            this.to.validityBuffer = BaseValueVector.transferBuffer(FixedSizeListVector.this.validityBuffer, this.to.allocator);
            this.to.setValueCount(FixedSizeListVector.this.valueCount);
            FixedSizeListVector.this.clear();
        }

        @Override
        public void splitAndTransfer(int startIndex, int length) {
            Preconditions.checkArgument(startIndex >= 0 && length >= 0 && startIndex + length <= FixedSizeListVector.this.valueCount, "Invalid parameters startIndex: %s, length: %s for valueCount: %s", (Object)startIndex, (Object)length, (Object)FixedSizeListVector.this.valueCount);
            int startPoint = FixedSizeListVector.this.listSize * startIndex;
            int sliceLength = FixedSizeListVector.this.listSize * length;
            this.to.clear();
            this.splitAndTransferValidityBuffer(startIndex, length, this.to);
            this.dataPair.splitAndTransfer(startPoint, sliceLength);
            this.to.setValueCount(length);
        }

        private void splitAndTransferValidityBuffer(int startIndex, int length, FixedSizeListVector target) {
            int firstByteSource = BitVectorHelper.byteIndex(startIndex);
            int lastByteSource = BitVectorHelper.byteIndex(FixedSizeListVector.this.valueCount - 1);
            int byteSizeTarget = FixedSizeListVector.getValidityBufferSizeFromCount(length);
            int offset = startIndex % 8;
            if (length > 0) {
                if (offset == 0) {
                    if (target.validityBuffer != null) {
                        target.validityBuffer.getReferenceManager().release();
                    }
                    target.validityBuffer = FixedSizeListVector.this.validityBuffer.slice(firstByteSource, byteSizeTarget);
                    target.validityBuffer.getReferenceManager().retain(1);
                } else {
                    byte b1;
                    target.allocateValidityBuffer(byteSizeTarget);
                    for (int i = 0; i < byteSizeTarget - 1; ++i) {
                        byte b12 = BitVectorHelper.getBitsFromCurrentByte(FixedSizeListVector.this.validityBuffer, firstByteSource + i, offset);
                        byte b2 = BitVectorHelper.getBitsFromNextByte(FixedSizeListVector.this.validityBuffer, firstByteSource + i + 1, offset);
                        target.validityBuffer.setByte((long)i, b12 + b2);
                    }
                    if (firstByteSource + byteSizeTarget - 1 < lastByteSource) {
                        b1 = BitVectorHelper.getBitsFromCurrentByte(FixedSizeListVector.this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                        byte b2 = BitVectorHelper.getBitsFromNextByte(FixedSizeListVector.this.validityBuffer, firstByteSource + byteSizeTarget, offset);
                        target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1 + b2);
                    } else {
                        b1 = BitVectorHelper.getBitsFromCurrentByte(FixedSizeListVector.this.validityBuffer, firstByteSource + byteSizeTarget - 1, offset);
                        target.validityBuffer.setByte((long)(byteSizeTarget - 1), b1);
                    }
                }
            }
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int fromIndex, int toIndex) {
            while (toIndex >= this.to.getValueCapacity()) {
                this.to.reAlloc();
            }
            BitVectorHelper.setValidityBit(this.to.validityBuffer, toIndex, FixedSizeListVector.this.isSet(fromIndex));
            int fromOffset = fromIndex * FixedSizeListVector.this.listSize;
            int toOffset = toIndex * FixedSizeListVector.this.listSize;
            for (int i = 0; i < FixedSizeListVector.this.listSize; ++i) {
                this.dataPair.copyValueSafe(fromOffset + i, toOffset + i);
            }
        }
    }
}

