/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.dictionary;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.BufferAllocator;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.hash.SimpleHasher;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.util.AutoCloseables;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BaseIntVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.FieldVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ValueVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.dictionary.Dictionary;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.dictionary.DictionaryHashTable;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.ArrowType;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.Field;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.FieldType;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.TransferPair;

public class DictionaryEncoder {
    private final DictionaryHashTable hashTable;
    private final Dictionary dictionary;
    private final BufferAllocator allocator;

    public DictionaryEncoder(Dictionary dictionary, BufferAllocator allocator) {
        this(dictionary, allocator, SimpleHasher.INSTANCE);
    }

    public DictionaryEncoder(Dictionary dictionary, BufferAllocator allocator, ArrowBufHasher hasher) {
        this.dictionary = dictionary;
        this.allocator = allocator;
        this.hashTable = new DictionaryHashTable(dictionary.getVector(), hasher);
    }

    public static ValueVector encode(ValueVector vector, Dictionary dictionary) {
        DictionaryEncoder encoder = new DictionaryEncoder(dictionary, vector.getAllocator());
        return encoder.encode(vector);
    }

    public static ValueVector decode(ValueVector indices, Dictionary dictionary) {
        return DictionaryEncoder.decode(indices, dictionary, indices.getAllocator());
    }

    public static ValueVector decode(ValueVector indices, Dictionary dictionary, BufferAllocator allocator) {
        int count = indices.getValueCount();
        FieldVector dictionaryVector = dictionary.getVector();
        int dictionaryCount = dictionaryVector.getValueCount();
        TransferPair transfer = dictionaryVector.getTransferPair(allocator);
        transfer.getTo().allocateNewSafe();
        try {
            BaseIntVector baseIntVector = (BaseIntVector)indices;
            DictionaryEncoder.retrieveIndexVector(baseIntVector, transfer, dictionaryCount, 0, count);
            ValueVector decoded = transfer.getTo();
            decoded.setValueCount(count);
            return decoded;
        }
        catch (Exception e) {
            AutoCloseables.close((Throwable)e, (Iterable<? extends AutoCloseable>)transfer.getTo());
            throw e;
        }
    }

    public static ArrowType.Int getIndexType(int valueCount) {
        Preconditions.checkArgument(valueCount >= 0);
        if (valueCount <= 127) {
            return new ArrowType.Int(8, true);
        }
        if (valueCount <= 65535) {
            return new ArrowType.Int(16, true);
        }
        if (valueCount <= Integer.MAX_VALUE) {
            return new ArrowType.Int(32, true);
        }
        return new ArrowType.Int(64, true);
    }

    static void buildIndexVector(ValueVector vector, BaseIntVector indices, DictionaryHashTable encoding, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (vector.isNull(i)) continue;
            int encoded = encoding.getIndex(i, vector);
            if (encoded == -1) {
                throw new IllegalArgumentException("Dictionary encoding not defined for value:" + String.valueOf(vector.getObject(i)));
            }
            indices.setWithPossibleTruncate(i, encoded);
        }
    }

    static void retrieveIndexVector(BaseIntVector indices, TransferPair transfer, int dictionaryCount, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (indices.isNull(i)) continue;
            int indexAsInt = (int)indices.getValueAsLong(i);
            if (indexAsInt > dictionaryCount) {
                throw new IllegalArgumentException("Provided dictionary does not contain value for index " + indexAsInt);
            }
            transfer.copyValueSafe(indexAsInt, i);
        }
    }

    public ValueVector encode(ValueVector vector) {
        Field valueField = vector.getField();
        FieldType indexFieldType = new FieldType(valueField.isNullable(), this.dictionary.getEncoding().getIndexType(), this.dictionary.getEncoding(), valueField.getMetadata());
        Field indexField = new Field(valueField.getName(), indexFieldType, null);
        FieldVector createdVector = indexField.createVector(this.allocator);
        if (!(createdVector instanceof BaseIntVector)) {
            throw new IllegalArgumentException("Dictionary encoding does not have a valid int type:" + String.valueOf(createdVector.getClass()));
        }
        BaseIntVector indices = (BaseIntVector)createdVector;
        indices.allocateNew();
        try {
            DictionaryEncoder.buildIndexVector(vector, indices, this.hashTable, 0, vector.getValueCount());
            indices.setValueCount(vector.getValueCount());
            return indices;
        }
        catch (Exception e) {
            AutoCloseables.close((Throwable)e, (Iterable<? extends AutoCloseable>)indices);
            throw e;
        }
    }

    public ValueVector decode(ValueVector indices) {
        return DictionaryEncoder.decode(indices, this.dictionary, this.allocator);
    }
}

