/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connector.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class NonInterruptibleBlockingBytesChannel
implements ReadableByteChannel {
    private static final int TRANSFER_SIZE = 4096;
    private final InputStream is;
    private boolean closed = false;
    private byte[] transferBuffer = new byte[4096];

    public NonInterruptibleBlockingBytesChannel(InputStream is) {
        this.is = is;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int bytesToRead;
        int totalRead;
        int len = dst.remaining();
        int bytesRead = 0;
        for (totalRead = 0; totalRead < len && (bytesRead = this.is.read(this.transferBuffer, 0, bytesToRead = Math.min(len - totalRead, 4096))) >= 0; totalRead += bytesRead) {
            dst.put(this.transferBuffer, 0, bytesRead);
        }
        if (bytesRead < 0 && totalRead == 0) {
            return -1;
        }
        return totalRead;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.is.close();
    }
}

