/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.impl;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.service.AutoService;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableMap;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.squareup.javapoet.CodeBlock;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.Serializer;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.SerializerExtension;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.SerializerFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.runtime.FunctionWithExceptions;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@AutoService(value={SerializerExtension.class})
public final class ImmutableMapSerializerExtension
implements SerializerExtension {
    @Override
    public Optional<Serializer> getSerializer(TypeMirror typeMirror, SerializerFactory factory, ProcessingEnvironment processingEnv) {
        if (!ImmutableMapSerializerExtension.isImmutableMap(typeMirror)) {
            return Optional.empty();
        }
        TypeMirror keyType = ImmutableMapSerializerExtension.getKeyType(typeMirror);
        TypeMirror valueType = ImmutableMapSerializerExtension.getValueType(typeMirror);
        Serializer keyTypeSerializer = factory.getSerializer(keyType);
        Serializer valueTypeSerializer = factory.getSerializer(valueType);
        if (keyTypeSerializer.isIdentity() && valueTypeSerializer.isIdentity()) {
            return Optional.empty();
        }
        return Optional.of(new ImmutableMapSerializer(keyType, valueType, keyTypeSerializer, valueTypeSerializer, factory, processingEnv));
    }

    private static boolean isImmutableMap(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        return MoreTypes.asTypeElement(type).getQualifiedName().contentEquals("com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableMap");
    }

    private static TypeMirror getKeyType(TypeMirror type) {
        return MoreTypes.asDeclared(type).getTypeArguments().get(0);
    }

    private static TypeMirror getValueType(TypeMirror type) {
        return MoreTypes.asDeclared(type).getTypeArguments().get(1);
    }

    private static class ImmutableMapSerializer
    implements Serializer {
        private final TypeMirror keyType;
        private final TypeMirror valueType;
        private final TypeMirror keyProxyType;
        private final TypeMirror valueProxyType;
        private final Serializer keyTypeSerializer;
        private final Serializer valueTypeSerializer;
        private final SerializerFactory factory;
        private final ProcessingEnvironment processingEnv;

        ImmutableMapSerializer(TypeMirror keyType, TypeMirror valueType, Serializer keyTypeSerializer, Serializer valueTypeSerializer, SerializerFactory factory, ProcessingEnvironment processingEnv) {
            this.keyType = keyType;
            this.valueType = valueType;
            this.keyProxyType = keyTypeSerializer.proxyFieldType();
            this.valueProxyType = valueTypeSerializer.proxyFieldType();
            this.keyTypeSerializer = keyTypeSerializer;
            this.valueTypeSerializer = valueTypeSerializer;
            this.factory = factory;
            this.processingEnv = processingEnv;
        }

        @Override
        public TypeMirror proxyFieldType() {
            TypeElement immutableMapTypeElement = this.processingEnv.getElementUtils().getTypeElement(ImmutableMap.class.getCanonicalName());
            return this.processingEnv.getTypeUtils().getDeclaredType(immutableMapTypeElement, this.keyProxyType, this.valueProxyType);
        }

        @Override
        public CodeBlock toProxy(CodeBlock expression) {
            Object[] objectArray = new Object[4];
            objectArray[0] = expression;
            objectArray[1] = ImmutableMap.class;
            objectArray[2] = this.generateKeyMapFunction(this.keyType, this.keyProxyType, this.keyTypeSerializer::toProxy);
            objectArray[3] = this.generateValueMapFunction(this.valueType, this.valueProxyType, this.valueTypeSerializer::toProxy);
            return CodeBlock.of("$L.entrySet().stream().collect($T.toImmutableMap($L, $L))", objectArray);
        }

        @Override
        public CodeBlock fromProxy(CodeBlock expression) {
            Object[] objectArray = new Object[4];
            objectArray[0] = expression;
            objectArray[1] = ImmutableMap.class;
            objectArray[2] = this.generateKeyMapFunction(this.keyProxyType, this.keyType, this.keyTypeSerializer::fromProxy);
            objectArray[3] = this.generateValueMapFunction(this.valueProxyType, this.valueType, this.valueTypeSerializer::fromProxy);
            return CodeBlock.of("$L.entrySet().stream().collect($T.toImmutableMap($L, $L))", objectArray);
        }

        private CodeBlock generateKeyMapFunction(TypeMirror originalType, TypeMirror transformedType, Function<CodeBlock, CodeBlock> proxyMap) {
            CodeBlock element = this.factory.newIdentifier("element");
            CodeBlock value = this.factory.newIdentifier("value");
            return CodeBlock.of("$1L -> $2T.<$3T, $4T>wrapper($5L -> $6L).apply($1L.getKey())", value, FunctionWithExceptions.class, originalType, transformedType, element, proxyMap.apply(element));
        }

        private CodeBlock generateValueMapFunction(TypeMirror originalType, TypeMirror transformedType, Function<CodeBlock, CodeBlock> proxyMap) {
            CodeBlock element = this.factory.newIdentifier("element");
            CodeBlock value = this.factory.newIdentifier("value");
            return CodeBlock.of("$1L -> $2T.<$3T, $4T>wrapper($5L -> $6L).apply($1L.getValue())", value, FunctionWithExceptions.class, originalType, transformedType, element, proxyMap.apply(element));
        }
    }
}

