/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring;

import com.google.cloud.spark.bigquery.repackaged.io.netty.buffer.ByteBufAllocator;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring.AbstractIoUringBufferRingAllocator;
import com.google.cloud.spark.bigquery.repackaged.io.netty.util.internal.AdaptiveCalculator;

public final class IoUringAdaptiveBufferRingAllocator
extends AbstractIoUringBufferRingAllocator {
    public static final int DEFAULT_MINIMUM = 1024;
    public static final int DEFAULT_INITIAL = 4096;
    public static final int DEFAULT_MAXIMUM = 65536;
    private final AdaptiveCalculator calculator;

    public IoUringAdaptiveBufferRingAllocator() {
        this(ByteBufAllocator.DEFAULT);
    }

    public IoUringAdaptiveBufferRingAllocator(ByteBufAllocator allocator) {
        this(allocator, 1024, 4096, 65536);
    }

    public IoUringAdaptiveBufferRingAllocator(ByteBufAllocator allocator, int minimum, int initial, int maximum) {
        this(allocator, minimum, initial, maximum, false);
    }

    public IoUringAdaptiveBufferRingAllocator(ByteBufAllocator allocator, int minimum, int initial, int maximum, boolean largeAllocation) {
        super(allocator, largeAllocation);
        this.calculator = new AdaptiveCalculator(minimum, initial, maximum);
    }

    @Override
    protected int nextBufferSize() {
        return this.calculator.nextSize();
    }

    @Override
    public void lastBytesRead(int attempted, int actual) {
        if (attempted == actual) {
            this.calculator.record(actual);
        }
    }
}

