/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring;

import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring.IoUring;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring.IoUringBufferRingAllocator;
import com.google.cloud.spark.bigquery.repackaged.io.netty.util.internal.MathUtil;
import com.google.cloud.spark.bigquery.repackaged.io.netty.util.internal.ObjectUtil;
import java.util.Objects;

public final class IoUringBufferRingConfig {
    private final short bgId;
    private final short bufferRingSize;
    private final int batchSize;
    private final int maxUnreleasedBuffers;
    private final boolean incremental;
    private final IoUringBufferRingAllocator allocator;
    private final boolean batchAllocation;

    @Deprecated
    public IoUringBufferRingConfig(short bgId, short bufferRingSize, int maxUnreleasedBuffers, IoUringBufferRingAllocator allocator) {
        this(bgId, bufferRingSize, bufferRingSize / 2, maxUnreleasedBuffers, IoUring.isRegisterBufferRingIncSupported(), allocator);
    }

    @Deprecated
    public IoUringBufferRingConfig(short bgId, short bufferRingSize, int batchSize, int maxUnreleasedBuffers, boolean incremental, IoUringBufferRingAllocator allocator) {
        this(bgId, bufferRingSize, batchSize, maxUnreleasedBuffers, incremental, allocator, false);
    }

    private IoUringBufferRingConfig(short bgId, short bufferRingSize, int batchSize, int maxUnreleasedBuffers, boolean incremental, IoUringBufferRingAllocator allocator, boolean batchAllocation) {
        this.bgId = (short)ObjectUtil.checkPositiveOrZero(bgId, "bgId");
        this.bufferRingSize = IoUringBufferRingConfig.checkBufferRingSize(bufferRingSize);
        this.batchSize = MathUtil.findNextPositivePowerOfTwo(ObjectUtil.checkInRange(batchSize, 1, bufferRingSize, "batchSize"));
        this.maxUnreleasedBuffers = ObjectUtil.checkInRange(maxUnreleasedBuffers, bufferRingSize, Integer.MAX_VALUE, "maxUnreleasedBuffers");
        if (incremental && !IoUring.isRegisterBufferRingIncSupported()) {
            throw new IllegalArgumentException("Incremental buffer ring is not supported");
        }
        this.incremental = incremental;
        this.allocator = ObjectUtil.checkNotNull(allocator, "allocator");
        this.batchAllocation = batchAllocation;
    }

    public short bufferGroupId() {
        return this.bgId;
    }

    public short bufferRingSize() {
        return this.bufferRingSize;
    }

    public int batchSize() {
        return this.batchSize;
    }

    @Deprecated
    public int maxUnreleasedBuffers() {
        return this.maxUnreleasedBuffers;
    }

    public IoUringBufferRingAllocator allocator() {
        return this.allocator;
    }

    public boolean isBatchAllocation() {
        return this.batchAllocation;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    private static short checkBufferRingSize(short bufferRingSize) {
        boolean isPowerOfTwo;
        if (bufferRingSize < 1) {
            throw new IllegalArgumentException("bufferRingSize: " + bufferRingSize + " (expected: > 0)");
        }
        boolean bl = isPowerOfTwo = (bufferRingSize & bufferRingSize - 1) == 0;
        if (!isPowerOfTwo) {
            throw new IllegalArgumentException("bufferRingSize: " + bufferRingSize + " (expected: power of 2)");
        }
        return bufferRingSize;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoUringBufferRingConfig that = (IoUringBufferRingConfig)o;
        return this.bgId == that.bgId;
    }

    public int hashCode() {
        return Objects.hashCode(this.bgId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private short bgId = (short)-1;
        private short bufferRingSize = (short)-1;
        private int batchSize = -1;
        private boolean incremental = IoUring.isRegisterBufferRingIncSupported();
        private IoUringBufferRingAllocator allocator;
        private boolean batchAllocation;

        public Builder bufferGroupId(short bgId) {
            this.bgId = bgId;
            return this;
        }

        public Builder bufferRingSize(short bufferRingSize) {
            this.bufferRingSize = bufferRingSize;
            return this;
        }

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder allocator(IoUringBufferRingAllocator allocator) {
            this.allocator = allocator;
            return this;
        }

        public Builder batchAllocation(boolean batchAllocation) {
            this.batchAllocation = batchAllocation;
            return this;
        }

        public Builder incremental(boolean incremental) {
            this.incremental = incremental;
            return this;
        }

        public IoUringBufferRingConfig build() {
            return new IoUringBufferRingConfig(this.bgId, this.bufferRingSize, this.batchSize, Integer.MAX_VALUE, this.incremental, this.allocator, this.batchAllocation);
        }
    }
}

