/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring;

import com.google.cloud.spark.bigquery.repackaged.io.netty.buffer.ByteBuf;
import com.google.cloud.spark.bigquery.repackaged.io.netty.buffer.ByteBufAllocator;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.ChannelConfig;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.RecvByteBufAllocator;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.unix.PreferredDirectByteBufAllocator;
import com.google.cloud.spark.bigquery.repackaged.io.netty.util.UncheckedBooleanSupplier;

final class IoUringRecvByteAllocatorHandle
extends RecvByteBufAllocator.DelegatingHandle
implements RecvByteBufAllocator.ExtendedHandle {
    private final PreferredDirectByteBufAllocator preferredDirectByteBufAllocator = new PreferredDirectByteBufAllocator();
    private final UncheckedBooleanSupplier defaultSupplier = () -> this.lastBytesRead() > 0;
    private boolean firstRead;
    private boolean rdHupReceived;
    private boolean readComplete;

    IoUringRecvByteAllocatorHandle(RecvByteBufAllocator.ExtendedHandle handle) {
        super(handle);
    }

    @Override
    public void reset(ChannelConfig config) {
        super.reset(config);
        this.readComplete = false;
        this.firstRead = true;
    }

    void rdHupReceived() {
        this.rdHupReceived = true;
    }

    @Override
    public ByteBuf allocate(ByteBufAllocator alloc) {
        this.preferredDirectByteBufAllocator.updateAllocator(alloc);
        return this.delegate().allocate(this.preferredDirectByteBufAllocator);
    }

    @Override
    public boolean continueReading() {
        return this.continueReading(this.defaultSupplier);
    }

    @Override
    public boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
        return ((RecvByteBufAllocator.ExtendedHandle)this.delegate()).continueReading(maybeMoreDataSupplier) || this.rdHupReceived;
    }

    public boolean isFirstRead() {
        return this.firstRead;
    }

    @Override
    public void readComplete() {
        super.readComplete();
        this.readComplete = true;
    }

    boolean isReadComplete() {
        return this.readComplete;
    }

    @Override
    public void lastBytesRead(int bytes) {
        this.firstRead = false;
        super.lastBytesRead(bytes);
    }

    @Override
    public void incMessagesRead(int numMessages) {
        this.firstRead = false;
        super.incMessagesRead(numMessages);
    }
}

