/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring;

import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.Channel;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.ChannelConfig;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.ChannelFuture;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.ChannelFutureListener;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.unix.DomainSocketAddress;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.unix.ServerDomainSocketChannel;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring.AbstractIoUringServerChannel;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring.IoUringDomainSocketChannel;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring.IoUringServerSocketChannelConfig;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring.LinuxSocket;
import com.google.cloud.spark.bigquery.repackaged.io.netty.util.concurrent.GenericFutureListener;
import com.google.cloud.spark.bigquery.repackaged.io.netty.util.internal.logging.InternalLogger;
import com.google.cloud.spark.bigquery.repackaged.io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

public final class IoUringServerDomainSocketChannel
extends AbstractIoUringServerChannel
implements ServerDomainSocketChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(IoUringServerDomainSocketChannel.class);
    private final IoUringServerSocketChannelConfig config = new IoUringServerSocketChannelConfig(this);
    private volatile DomainSocketAddress local;

    public IoUringServerDomainSocketChannel() {
        super(LinuxSocket.newSocketDomain(), false);
        this.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                File socketFile;
                boolean success;
                if (IoUringServerDomainSocketChannel.this.local != null && !(success = (socketFile = new File(IoUringServerDomainSocketChannel.this.local.path())).delete()) && logger.isDebugEnabled()) {
                    logger.debug("Failed to delete a domain socket file: {}", (Object)IoUringServerDomainSocketChannel.this.local.path());
                }
            }
        });
    }

    @Override
    Channel newChildChannel(int fd, ByteBuffer acceptedAddressMemory) throws Exception {
        return new IoUringDomainSocketChannel((Channel)this, new LinuxSocket(fd));
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public DomainSocketAddress localAddress() {
        return this.local;
    }

    @Override
    public DomainSocketAddress remoteAddress() {
        return (DomainSocketAddress)super.remoteAddress();
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
        this.socket.bind(localAddress);
        this.socket.listen(this.config.getBacklog());
        this.local = (DomainSocketAddress)localAddress;
        this.active = true;
    }
}

