/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring;

import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.uring.Native;
import java.nio.ByteBuffer;

final class Iov {
    private Iov() {
    }

    static void set(ByteBuffer buffer, long bufferAddress, int length) {
        int position = buffer.position();
        if (Native.SIZEOF_SIZE_T == 4) {
            buffer.putInt(position + Native.IOVEC_OFFSETOF_IOV_BASE, (int)bufferAddress);
            buffer.putInt(position + Native.IOVEC_OFFSETOF_IOV_LEN, length);
        } else {
            assert (Native.SIZEOF_SIZE_T == 8);
            buffer.putLong(position + Native.IOVEC_OFFSETOF_IOV_BASE, bufferAddress);
            buffer.putLong(position + Native.IOVEC_OFFSETOF_IOV_LEN, length);
        }
    }

    static long getBufferAddress(ByteBuffer iov) {
        if (Native.SIZEOF_SIZE_T == 4) {
            return iov.getInt(iov.position() + Native.IOVEC_OFFSETOF_IOV_BASE);
        }
        assert (Native.SIZEOF_SIZE_T == 8);
        return iov.getLong(iov.position() + Native.IOVEC_OFFSETOF_IOV_BASE);
    }

    static int getBufferLength(ByteBuffer iov) {
        if (Native.SIZEOF_SIZE_T == 4) {
            return iov.getInt(iov.position() + Native.IOVEC_OFFSETOF_IOV_LEN);
        }
        assert (Native.SIZEOF_SIZE_T == 8);
        return (int)iov.getLong(iov.position() + Native.IOVEC_OFFSETOF_IOV_LEN);
    }
}

