/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.netty.handler.codec.quic;

import com.google.cloud.spark.bigquery.repackaged.io.netty.buffer.ByteBuf;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.epoll.SegmentedDatagramPacket;
import com.google.cloud.spark.bigquery.repackaged.io.netty.channel.socket.DatagramPacket;
import com.google.cloud.spark.bigquery.repackaged.io.netty.handler.codec.quic.SegmentedDatagramPacketAllocator;
import com.google.cloud.spark.bigquery.repackaged.io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;

public final class EpollQuicUtils {
    private EpollQuicUtils() {
    }

    public static SegmentedDatagramPacketAllocator newSegmentedAllocator(int maxNumSegments) {
        ObjectUtil.checkInRange(maxNumSegments, 1, 64, "maxNumSegments");
        if (SegmentedDatagramPacket.isSupported()) {
            return new EpollSegmentedDatagramPacketAllocator(maxNumSegments);
        }
        return SegmentedDatagramPacketAllocator.NONE;
    }

    private static final class EpollSegmentedDatagramPacketAllocator
    implements SegmentedDatagramPacketAllocator {
        private final int maxNumSegments;

        EpollSegmentedDatagramPacketAllocator(int maxNumSegments) {
            this.maxNumSegments = maxNumSegments;
        }

        @Override
        public int maxNumSegments() {
            return this.maxNumSegments;
        }

        @Override
        public DatagramPacket newPacket(ByteBuf buffer, int segmentSize, InetSocketAddress remoteAddress) {
            return new com.google.cloud.spark.bigquery.repackaged.io.netty.channel.unix.SegmentedDatagramPacket(buffer, segmentSize, remoteAddress);
        }
    }
}

