/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver.DatasetNamespaceResolver;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.dataset.namespace.resolver.HostListNamespaceResolverConfig;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.lang3.StringUtils;

public class HostListNamespaceResolver
implements DatasetNamespaceResolver {
    private final String resolvedName;
    private final HostListNamespaceResolverConfig config;

    public HostListNamespaceResolver(String resolvedName, HostListNamespaceResolverConfig config) {
        this.resolvedName = resolvedName;
        this.config = config;
    }

    @Override
    public String resolve(String namespace) {
        if (this.config.getHosts() == null) {
            return namespace;
        }
        if (StringUtils.isNotEmpty((CharSequence)this.config.getSchema()) && !namespace.startsWith(this.config.getSchema() + "://")) {
            return namespace;
        }
        return this.config.getHosts().stream().filter(h2 -> StringUtils.containsIgnoreCase((CharSequence)namespace, (CharSequence)h2)).findAny().map(h2 -> StringUtils.replaceIgnoreCase((String)namespace, (String)h2, (String)this.resolvedName)).orElseGet(() -> namespace);
    }
}

