/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.job;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.MergeConfig;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.TagField;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.TagsDeserializer;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.annotation.JsonAnySetter;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.lang3.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;

public class JobConfig
implements MergeConfig<JobConfig> {
    private JobOwnersConfig owners;
    private String namespace;
    private String name;
    @JsonDeserialize(using=TagsDeserializer.class)
    private List<TagField> tags = Collections.emptyList();

    @Override
    public JobConfig mergeWithNonNull(JobConfig other) {
        HashMap tagMap = new HashMap();
        if (this.tags != null) {
            this.tags.forEach(tag -> tagMap.put(tag.getKey(), tag));
        }
        if (other.getTags() != null) {
            other.getTags().forEach(tag -> tagMap.put(tag.getKey(), tag));
        }
        JobConfig jobConfig = new JobConfig();
        JobOwnersConfig newOwners = new JobOwnersConfig();
        newOwners.getAdditionalProperties().putAll(this.owners.getAdditionalProperties());
        newOwners.getAdditionalProperties().putAll(other.owners.getAdditionalProperties());
        jobConfig.setOwners(newOwners);
        jobConfig.setTags(new ArrayList<TagField>(tagMap.values()));
        jobConfig.name = StringUtils.isNotBlank((CharSequence)other.name) ? other.name : this.name;
        jobConfig.namespace = StringUtils.isNotBlank((CharSequence)other.namespace) ? other.namespace : this.namespace;
        return jobConfig;
    }

    @Generated
    public JobOwnersConfig getOwners() {
        return this.owners;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<TagField> getTags() {
        return this.tags;
    }

    @Generated
    public void setOwners(JobOwnersConfig owners) {
        this.owners = owners;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @JsonDeserialize(using=TagsDeserializer.class)
    @Generated
    public void setTags(List<TagField> tags) {
        this.tags = tags;
    }

    @Generated
    public String toString() {
        return "JobConfig(owners=" + this.getOwners() + ", namespace=" + this.getNamespace() + ", name=" + this.getName() + ", tags=" + this.getTags() + ")";
    }

    public static class JobOwnersConfig {
        @JsonAnySetter
        @NonNull
        private final Map<String, String> additionalProperties = new HashMap<String, String>();

        @NonNull
        @Generated
        public Map<String, String> getAdditionalProperties() {
            return this.additionalProperties;
        }

        @Generated
        public String toString() {
            return "JobConfig.JobOwnersConfig(additionalProperties=" + this.getAdditionalProperties() + ")";
        }
    }
}

