/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.filesystem;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.DatasetIdentifier;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.filesystem.FilesystemDatasetExtractor;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.filesystem.FilesystemUriSanitizer;
import com.google.cloud.spark.bigquery.repackaged.org.apache.commons.lang3.StringUtils;
import java.net.URI;
import java.util.Optional;

public class LocalFilesystemDatasetExtractor
implements FilesystemDatasetExtractor {
    private static final String SCHEME = "file";

    @Override
    public boolean isDefinedAt(URI location) {
        return location.getScheme() == null || location.getScheme().equals(SCHEME);
    }

    @Override
    public DatasetIdentifier extract(URI location) {
        String name = Optional.ofNullable(location.getPath()).map(FilesystemUriSanitizer::removeLastSlash).map(FilesystemUriSanitizer::nonEmptyPath).get();
        return new DatasetIdentifier(name, SCHEME);
    }

    @Override
    public DatasetIdentifier extract(URI location, String rawName) {
        String path = FilesystemUriSanitizer.removeLastSlash(location.getPath());
        String namespace = StringUtils.isNotEmpty((CharSequence)path) ? String.format("%s:%s", SCHEME, path) : SCHEME;
        String name = Optional.of(rawName).map(FilesystemUriSanitizer::removeLastSlash).map(FilesystemUriSanitizer::nonEmptyPath).get();
        return new DatasetIdentifier(name, namespace);
    }
}

