/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.ArrowBuf;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.BufferAllocator;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.OutOfMemoryException;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.ByteFunctionHelpers;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.memory.util.hash.ArrowBufHasher;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.util.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BaseIntVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BaseValueVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BigIntVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.BufferBacked;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.FieldVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.IntVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.SmallIntVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ValueVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ZeroVector;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.compare.VectorVisitor;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.reader.FieldReader;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.writer.FieldWriter;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.ipc.message.ArrowFieldNode;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.Types;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.ArrowType;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.Field;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.pojo.FieldType;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.CallBack;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.util.TransferPair;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class RunEndEncodedVector
extends BaseValueVector
implements FieldVector {
    public static final FieldVector DEFAULT_VALUE_VECTOR = ZeroVector.INSTANCE;
    public static final FieldVector DEFAULT_RUN_END_VECTOR = ZeroVector.INSTANCE;
    protected final CallBack callBack;
    protected Field field;
    protected FieldVector runEndsVector;
    protected FieldVector valuesVector;
    protected int valueCount;

    public static RunEndEncodedVector empty(String name, BufferAllocator allocator) {
        return new RunEndEncodedVector(name, allocator, FieldType.notNullable(ArrowType.RunEndEncoded.INSTANCE), null);
    }

    public RunEndEncodedVector(String name, BufferAllocator allocator, FieldType fieldType, CallBack callBack) {
        this(new Field(name, fieldType, null), allocator, callBack);
    }

    public RunEndEncodedVector(Field field, BufferAllocator allocator, CallBack callBack) {
        this(field, allocator, DEFAULT_RUN_END_VECTOR, DEFAULT_VALUE_VECTOR, callBack);
    }

    public RunEndEncodedVector(Field field, BufferAllocator allocator, FieldVector runEndsVector, FieldVector valuesVector, CallBack callBack) {
        super(allocator);
        this.field = field;
        this.callBack = callBack;
        this.valueCount = 0;
        this.runEndsVector = runEndsVector;
        this.valuesVector = valuesVector;
    }

    @Override
    public void allocateNew() throws OutOfMemoryException {
        if (!this.allocateNewSafe()) {
            throw new OutOfMemoryException("Failure while allocating memory");
        }
    }

    @Override
    public boolean allocateNewSafe() {
        this.initializeChildrenFromFields(this.field.getChildren());
        for (FieldVector v : this.getChildrenFromFields()) {
            boolean isAllocated = v.allocateNewSafe();
            if (isAllocated) continue;
            v.clear();
            return false;
        }
        return true;
    }

    @Override
    public void reAlloc() {
        for (FieldVector v : this.getChildrenFromFields()) {
            v.reAlloc();
        }
    }

    @Override
    public BufferAllocator getAllocator() {
        return this.allocator;
    }

    @Override
    protected FieldReader getReaderImpl() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public void setInitialCapacity(int numRecords) {
    }

    @Override
    public int getValueCapacity() {
        return this.getChildrenFromFields().stream().mapToInt(item -> item != null ? item.getValueCapacity() : 0).min().orElseThrow(NoSuchElementException::new);
    }

    @Override
    public void close() {
        for (FieldVector v : this.getChildrenFromFields()) {
            v.close();
        }
    }

    @Override
    public void clear() {
        for (FieldVector v : this.getChildrenFromFields()) {
            v.clear();
        }
        this.valueCount = 0;
    }

    @Override
    public void reset() {
        for (FieldVector v : this.getChildrenFromFields()) {
            v.reset();
        }
        this.valueCount = 0;
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.RUNENDENCODED;
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator) {
        return this.getTransferPair(ref, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator) {
        return this.getTransferPair(field, allocator, null);
    }

    @Override
    public TransferPair getTransferPair(String ref, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(ref, allocator, callBack);
    }

    @Override
    public TransferPair getTransferPair(Field field, BufferAllocator allocator, CallBack callBack) {
        return new TransferImpl(field, allocator, callBack);
    }

    @Override
    public TransferPair makeTransferPair(ValueVector target) {
        return new TransferImpl((RunEndEncodedVector)target);
    }

    @Override
    public FieldReader getReader() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public FieldWriter getWriter() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public int getBufferSize() {
        int bufferSize = 0;
        for (FieldVector v : this.getChildrenFromFields()) {
            bufferSize += v.getBufferSize();
        }
        return bufferSize;
    }

    @Override
    public int getBufferSizeFor(int valueCount) {
        return 0;
    }

    @Override
    public ArrowBuf[] getBuffers(boolean clear) {
        return new ArrowBuf[0];
    }

    @Override
    public ArrowBuf getValidityBuffer() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a validity buffer.");
    }

    @Override
    public ArrowBuf getDataBuffer() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a data buffer.");
    }

    @Override
    public ArrowBuf getOffsetBuffer() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a offset buffer.");
    }

    @Override
    public int getValueCount() {
        return this.valueCount;
    }

    @Override
    public void setValueCount(int valueCount) {
        this.valueCount = valueCount;
    }

    @Override
    public Object getObject(int index) {
        this.checkIndex(index);
        int physicalIndex = this.getPhysicalIndex(index);
        return this.valuesVector.getObject(physicalIndex);
    }

    public int getRunEnd(int index) {
        this.checkIndex(index);
        int physicalIndex = this.getPhysicalIndex(index);
        return (int)((BaseIntVector)this.runEndsVector).getValueAsLong(physicalIndex);
    }

    @Override
    public int getNullCount() {
        return 0;
    }

    @Override
    public boolean isNull(int index) {
        int physicalIndex = RunEndEncodedVector.getPhysicalIndex(this.runEndsVector, index);
        return this.valuesVector.isNull(physicalIndex);
    }

    @Override
    public int hashCode(int index) {
        return this.hashCode(index, null);
    }

    @Override
    public int hashCode(int index, ArrowBufHasher hasher) {
        int hash = 0;
        for (FieldVector v : this.getChildrenFromFields()) {
            if (index >= v.getValueCount()) continue;
            hash = ByteFunctionHelpers.combineHash(hash, v.hashCode(index, hasher));
        }
        return hash;
    }

    @Override
    public <OUT, IN> OUT accept(VectorVisitor<OUT, IN> visitor, IN value) {
        return visitor.visit(this, value);
    }

    @Override
    public String getName() {
        return this.field.getName();
    }

    @Override
    public Iterator<ValueVector> iterator() {
        return Collections.unmodifiableCollection(this.getChildrenFromFields()).iterator();
    }

    @Override
    public void initializeChildrenFromFields(List<Field> children) {
        Preconditions.checkArgument(children.size() == 2, "Run-end encoded vectors must have two child Fields. Found: %s", children.isEmpty() ? "none" : children);
        Preconditions.checkArgument(Arrays.asList(Types.MinorType.SMALLINT.getType(), Types.MinorType.INT.getType(), Types.MinorType.BIGINT.getType()).contains(children.get(0).getType()), "The first field represents the run-end vector and must be of type int with size 16, 32, or 64 bits. Found: %s", (Object)children.get(0).getType());
        this.runEndsVector = (BaseIntVector)children.get(0).createVector(this.allocator);
        this.valuesVector = children.get(1).createVector(this.allocator);
        this.field = new Field(this.field.getName(), this.field.getFieldType(), children);
    }

    @Override
    public List<FieldVector> getChildrenFromFields() {
        return Arrays.asList(this.runEndsVector, this.valuesVector);
    }

    @Override
    public void loadFieldBuffers(ArrowFieldNode fieldNode, List<ArrowBuf> ownBuffers) {
        if (!ownBuffers.isEmpty()) {
            throw new UnsupportedOperationException("Run-end encoded vectors do not have any associated buffers.");
        }
        this.valueCount = fieldNode.getLength();
    }

    @Override
    public List<ArrowBuf> getFieldBuffers() {
        return List.of();
    }

    @Override
    @Deprecated
    public List<BufferBacked> getFieldInnerVectors() {
        throw new UnsupportedOperationException("There are no inner vectors. Use getFieldBuffers().");
    }

    @Override
    public long getValidityBufferAddress() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a validity buffer.");
    }

    @Override
    public long getDataBufferAddress() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a data buffer.");
    }

    @Override
    public long getOffsetBufferAddress() {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have an offset buffer.");
    }

    @Override
    public void setNull(int index) {
        throw new UnsupportedOperationException("Run-end encoded vectors do not have a validity buffer.");
    }

    public FieldVector getRunEndsVector() {
        return this.runEndsVector;
    }

    public FieldVector getValuesVector() {
        return this.valuesVector;
    }

    private void checkIndex(int logicalIndex) {
        if (logicalIndex < 0 || logicalIndex >= this.valueCount) {
            throw new IndexOutOfBoundsException(String.format("index: %s, expected range (0, %s)", logicalIndex, this.valueCount));
        }
    }

    public int getPhysicalIndex(int logicalIndex) {
        return RunEndEncodedVector.getPhysicalIndex(this.runEndsVector, logicalIndex);
    }

    static int getPhysicalIndex(FieldVector runEndVector, int logicalIndex) {
        if (runEndVector == null || runEndVector.getValueCount() == 0) {
            return -1;
        }
        int low = 0;
        int high = runEndVector.getValueCount() - 1;
        int result = -1;
        while (low <= high) {
            int mid = low + (high - low) / 2;
            long valueAsLong = ((BaseIntVector)runEndVector).getValueAsLong(mid);
            if (valueAsLong > (long)logicalIndex) {
                result = mid;
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return result;
    }

    private class TransferImpl
    implements TransferPair {
        RunEndEncodedVector to;
        TransferPair dataTransferPair;
        TransferPair reeTransferPair;

        public TransferImpl(String name, BufferAllocator allocator, CallBack callBack) {
            this(new RunEndEncodedVector(name, allocator, runEndEncodedVector.field.getFieldType(), callBack));
        }

        public TransferImpl(Field field, BufferAllocator allocator, CallBack callBack) {
            this(new RunEndEncodedVector(field, allocator, callBack));
        }

        public TransferImpl(RunEndEncodedVector to) {
            this.to = to;
            if (to.getRunEndsVector() instanceof ZeroVector) {
                to.initializeChildrenFromFields(RunEndEncodedVector.this.field.getChildren());
            }
            this.reeTransferPair = RunEndEncodedVector.this.getRunEndsVector().makeTransferPair(to.getRunEndsVector());
            this.dataTransferPair = RunEndEncodedVector.this.getValuesVector().makeTransferPair(to.getValuesVector());
        }

        @Override
        public void transfer() {
            this.to.clear();
            this.dataTransferPair.transfer();
            this.reeTransferPair.transfer();
            if (RunEndEncodedVector.this.valueCount > 0) {
                this.to.setValueCount(RunEndEncodedVector.this.valueCount);
            }
            RunEndEncodedVector.this.clear();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void splitAndTransfer(int startIndex, int length) {
            this.to.clear();
            if (length <= 0) {
                return;
            }
            int physicalStartIndex = RunEndEncodedVector.this.getPhysicalIndex(startIndex);
            int physicalEndIndex = RunEndEncodedVector.this.getPhysicalIndex(startIndex + length - 1);
            int physicalLength = physicalEndIndex - physicalStartIndex + 1;
            this.dataTransferPair.splitAndTransfer(physicalStartIndex, physicalLength);
            FieldVector toRunEndsVector = this.to.runEndsVector;
            if (startIndex == 0) {
                if (((BaseIntVector)RunEndEncodedVector.this.runEndsVector).getValueAsLong(physicalEndIndex) == (long)length) {
                    this.reeTransferPair.splitAndTransfer(physicalStartIndex, physicalLength);
                } else {
                    this.reeTransferPair.splitAndTransfer(physicalStartIndex, physicalLength - 1);
                    toRunEndsVector.setValueCount(physicalLength);
                    if (toRunEndsVector instanceof SmallIntVector) {
                        ((SmallIntVector)toRunEndsVector).set(physicalEndIndex, length);
                    } else if (toRunEndsVector instanceof IntVector) {
                        ((IntVector)toRunEndsVector).set(physicalEndIndex, length);
                    } else {
                        if (!(toRunEndsVector instanceof BigIntVector)) throw new IllegalArgumentException("Run-end vector and must be of type int with size 16, 32, or 64 bits.");
                        ((BigIntVector)toRunEndsVector).set(physicalEndIndex, length);
                    }
                }
            } else {
                this.shiftRunEndsVector(toRunEndsVector, startIndex, length, physicalStartIndex, physicalEndIndex, physicalLength);
            }
            this.getTo().setValueCount(length);
        }

        private void shiftRunEndsVector(ValueVector toRunEndVector, int startIndex, int length, int physicalStartIndex, int physicalEndIndex, int physicalLength) {
            toRunEndVector.setValueCount(physicalLength);
            toRunEndVector.getValidityBuffer().setOne(0L, toRunEndVector.getValidityBuffer().capacity());
            ArrowBuf fromRunEndBuffer = RunEndEncodedVector.this.runEndsVector.getDataBuffer();
            ArrowBuf toRunEndBuffer = toRunEndVector.getDataBuffer();
            int physicalLastIndex = physicalLength - 1;
            if (toRunEndVector instanceof SmallIntVector) {
                int typeWidth = 2;
                for (int i = 0; i < physicalLastIndex; ++i) {
                    toRunEndBuffer.setShort((long)i * (long)typeWidth, fromRunEndBuffer.getShort((long)(i + physicalStartIndex) * (long)typeWidth) - startIndex);
                }
                int lastEnd = Math.min(fromRunEndBuffer.getShort((long)physicalEndIndex * (long)typeWidth) - startIndex, length);
                toRunEndBuffer.setShort((long)physicalLastIndex * (long)typeWidth, lastEnd);
            } else if (toRunEndVector instanceof IntVector) {
                int typeWidth = 4;
                for (int i = 0; i < physicalLastIndex; ++i) {
                    toRunEndBuffer.setInt((long)i * (long)typeWidth, fromRunEndBuffer.getInt((long)(i + physicalStartIndex) * (long)typeWidth) - startIndex);
                }
                int lastEnd = Math.min(fromRunEndBuffer.getInt((long)physicalEndIndex * (long)typeWidth) - startIndex, length);
                toRunEndBuffer.setInt((long)physicalLastIndex * (long)typeWidth, lastEnd);
            } else if (toRunEndVector instanceof BigIntVector) {
                int typeWidth = 8;
                for (int i = 0; i < physicalLastIndex; ++i) {
                    toRunEndBuffer.setLong((long)i * (long)typeWidth, fromRunEndBuffer.getLong((long)(i + physicalStartIndex) * (long)typeWidth) - (long)startIndex);
                }
                long lastEnd = Math.min(fromRunEndBuffer.getLong((long)physicalEndIndex * (long)typeWidth) - (long)startIndex, (long)length);
                toRunEndBuffer.setLong((long)physicalLastIndex * (long)typeWidth, lastEnd);
            } else {
                throw new IllegalArgumentException("Run-end vector and must be of type int with size 16, 32, or 64 bits.");
            }
        }

        @Override
        public ValueVector getTo() {
            return this.to;
        }

        @Override
        public void copyValueSafe(int from, int to) {
            this.to.copyFrom(from, to, RunEndEncodedVector.this);
        }
    }
}

