/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.tracing;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.core.ApiFutureCallback;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.gax.tracing.ApiTracer;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import java.util.concurrent.CancellationException;
import javax.annotation.Nonnull;

class TraceFinisher<T>
implements ApiFutureCallback<T> {
    private final ApiTracer tracer;

    TraceFinisher(@Nonnull ApiTracer tracer) {
        this.tracer = Preconditions.checkNotNull(tracer, "tracer can't be null");
    }

    @Override
    public void onFailure(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.tracer.operationCancelled();
        } else {
            this.tracer.operationFailed(throwable);
        }
    }

    @Override
    public void onSuccess(T responseT) {
        this.tracer.operationSucceeded();
    }
}

