/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc.JdbcExtractor;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc.JdbcLocation;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc.OverridingJdbcExtractor;
import java.net.URISyntaxException;
import java.util.Properties;

public class MySqlJdbcExtractor
implements JdbcExtractor {
    private static final String PROTOCOL_PART = "^[\\w+:]+://";

    private JdbcExtractor delegate() {
        return new OverridingJdbcExtractor("mysql", "3306");
    }

    @Override
    public boolean isDefinedAt(String jdbcUri) {
        return this.delegate().isDefinedAt(jdbcUri);
    }

    @Override
    public JdbcLocation extract(String rawUri, Properties properties) throws URISyntaxException {
        String normalizedUri = rawUri.replaceFirst(PROTOCOL_PART, "mysql://");
        return this.delegate().extract(normalizedUri, properties);
    }
}

