/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.TableConstraints;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.AutoValue;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.AutoValue_ForeignKey;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.ColumnReference;
import com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.TableId;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

@AutoValue
public abstract class ForeignKey
implements Serializable {
    public static Builder newBuilder() {
        return new AutoValue_ForeignKey.Builder();
    }

    static ForeignKey fromPb(TableConstraints.ForeignKeys foreignKey) {
        Builder builder = ForeignKey.newBuilder();
        if (foreignKey.getName() != null) {
            builder.setName(foreignKey.getName());
        }
        if (foreignKey.getReferencedTable() != null) {
            TableConstraints.ForeignKeys.ReferencedTable referencedTable = foreignKey.getReferencedTable();
            builder.setReferencedTable(TableId.of(referencedTable.getProjectId(), referencedTable.getDatasetId(), referencedTable.getTableId()));
        }
        if (foreignKey.getColumnReferences() != null) {
            builder.setColumnReferences(foreignKey.getColumnReferences().stream().map(ColumnReference::fromPb).collect(Collectors.toList()));
        }
        return builder.build();
    }

    TableConstraints.ForeignKeys toPb() {
        TableConstraints.ForeignKeys foreignKey = new TableConstraints.ForeignKeys();
        if (this.getName() != null) {
            foreignKey.setName(this.getName());
        }
        if (this.getReferencedTable() != null) {
            TableId referencedTableId = this.getReferencedTable();
            foreignKey.setReferencedTable(new TableConstraints.ForeignKeys.ReferencedTable().setTableId(referencedTableId.getTable()).setDatasetId(referencedTableId.getDataset()).setProjectId(referencedTableId.getProject()));
        }
        if (this.getColumnReferences() != null) {
            foreignKey.setColumnReferences(this.getColumnReferences().stream().map(ColumnReference::toPb).collect(Collectors.toList()));
        }
        return foreignKey;
    }

    @Nullable
    public abstract String getName();

    @Nullable
    public abstract TableId getReferencedTable();

    @Nullable
    public abstract List<ColumnReference> getColumnReferences();

    @VisibleForTesting
    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setName(String var1);

        public abstract Builder setReferencedTable(TableId var1);

        public abstract Builder setColumnReferences(List<ColumnReference> var1);

        public abstract ForeignKey build();
    }
}

