/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.RangePartitioning;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.MoreObjects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Objects;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Strings;
import java.io.Serializable;

public final class RangePartitioning
implements Serializable {
    private static final long serialVersionUID = 2011646901758026886L;
    private final String field;
    private final Range range;

    private RangePartitioning(Builder builder) {
        this.field = builder.field;
        this.range = builder.range;
    }

    private RangePartitioning(com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.RangePartitioning rangePartitioning) {
        this.field = rangePartitioning.getField();
        this.range = Range.fromPb(rangePartitioning.getRange());
    }

    public String getField() {
        return this.field;
    }

    public Range getRange() {
        return this.range;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("field", this.field).add("range", this.range).toString();
    }

    public int hashCode() {
        return Objects.hashCode(this.field, this.range);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(RangePartitioning.class) && java.util.Objects.equals(this.toPb(), ((RangePartitioning)obj).toPb());
    }

    com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.RangePartitioning toPb() {
        com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.RangePartitioning rangePartitioning = new com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.RangePartitioning();
        rangePartitioning.setField(this.field);
        rangePartitioning.setRange(this.range.toPb());
        return rangePartitioning;
    }

    static RangePartitioning fromPb(com.google.cloud.spark.bigquery.repackaged.com.google.api.services.bigquery.model.RangePartitioning rangePartitioning) {
        return new RangePartitioning(rangePartitioning);
    }

    public static final class Builder {
        private String field;
        private Range range;

        private Builder() {
        }

        private Builder(RangePartitioning rangePartitioning) {
            this.field = rangePartitioning.field;
            this.range = rangePartitioning.range;
        }

        public Builder setField(String field) {
            Preconditions.checkArgument(!Strings.isNullOrEmpty(field), "Provided field is null or empty");
            this.field = field;
            return this;
        }

        public Builder setRange(Range range) {
            this.range = range;
            return this;
        }

        public RangePartitioning build() {
            return new RangePartitioning(this);
        }
    }

    public static final class Range
    implements Serializable {
        private static final long serialVersionUID = -7603436109151103007L;
        private final Long end;
        private final Long interval;
        private final Long start;

        private Range(Builder builder) {
            this.end = builder.end;
            this.interval = builder.interval;
            this.start = builder.start;
        }

        private Range(RangePartitioning.Range range) {
            this.end = range.getEnd();
            this.interval = range.getInterval();
            this.start = range.getStart();
        }

        public Long getEnd() {
            return this.end;
        }

        public Long getInterval() {
            return this.interval;
        }

        public Long getStart() {
            return this.start;
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("end", this.end).add("interval", this.interval).add("start", this.start).toString();
        }

        public int hashCode() {
            return Objects.hashCode(this.end, this.interval, this.start);
        }

        public boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(Range.class) && java.util.Objects.equals(this.toPb(), ((Range)obj).toPb());
        }

        RangePartitioning.Range toPb() {
            RangePartitioning.Range range = new RangePartitioning.Range();
            range.setEnd(this.end);
            range.setInterval(this.interval);
            range.setStart(this.start);
            return range;
        }

        static Range fromPb(RangePartitioning.Range range) {
            return new Range(range);
        }

        public static final class Builder {
            private Long end;
            private Long interval;
            private Long start;

            private Builder() {
            }

            public Builder setEnd(Long end) {
                this.end = end;
                return this;
            }

            public Builder setInterval(Long interval) {
                this.interval = interval;
                return this;
            }

            public Builder setStart(Long start) {
                this.start = start;
                return this;
            }

            public Range build() {
                return new Range(this);
            }
        }
    }
}

