/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.module.blackbird.ser;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.core.JsonGenerator;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.JsonSerializer;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.PropertyName;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.SerializerProvider;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.com.fasterxml.jackson.module.blackbird.ser.OptimizedBeanPropertyWriter;
import java.util.function.ToIntFunction;

final class IntPropertyWriter
extends OptimizedBeanPropertyWriter<IntPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final int _suppressableInt;
    private final boolean _suppressableIntSet;
    private final ToIntFunction<Object> _acc;

    public IntPropertyWriter(BeanPropertyWriter src, ToIntFunction<Object> acc, JsonSerializer<Object> ser) {
        super(src, ser);
        this._acc = acc;
        if (this._suppressableValue instanceof Integer) {
            this._suppressableInt = (Integer)this._suppressableValue;
            this._suppressableIntSet = true;
        } else {
            this._suppressableInt = 0;
            this._suppressableIntSet = false;
        }
    }

    protected IntPropertyWriter(IntPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableInt = base._suppressableInt;
        this._suppressableIntSet = base._suppressableIntSet;
        this._acc = base._acc;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new IntPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new IntPropertyWriter(this, this._acc, ser);
    }

    @Override
    public final void serializeAsField(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsField(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.applyAsInt(bean);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, false);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            gen.writeFieldName(this._fastName);
            gen.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator gen, SerializerProvider prov) throws Exception {
        int value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, gen, prov);
            return;
        }
        try {
            value = this._acc.applyAsInt(bean);
        }
        catch (Throwable t2) {
            this._handleProblem(bean, gen, prov, t2, true);
            return;
        }
        if (!this._suppressableIntSet || this._suppressableInt != value) {
            gen.writeNumber(value);
        } else {
            this.serializeAsPlaceholder(bean, gen, prov);
        }
    }
}

