/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.impl;

import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.PeriodDuration;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.impl.AbstractFieldReader;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.complex.writer.IntervalMonthDayNanoWriter;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.holders.IntervalMonthDayNanoHolder;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.holders.NullableIntervalMonthDayNanoHolder;
import com.google.cloud.spark.bigquery.repackaged.org.apache.arrow.vector.types.Types;
import java.time.Duration;
import java.time.Period;

public class IntervalMonthDayNanoHolderReaderImpl
extends AbstractFieldReader {
    private IntervalMonthDayNanoHolder holder;

    public IntervalMonthDayNanoHolderReaderImpl(IntervalMonthDayNanoHolder holder) {
        this.holder = holder;
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("You can't call size on a Holder value reader.");
    }

    @Override
    public boolean next() {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public void setPosition(int index) {
        throw new UnsupportedOperationException("You can't call next on a single value reader.");
    }

    @Override
    public Types.MinorType getMinorType() {
        return Types.MinorType.INTERVALMONTHDAYNANO;
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public void read(IntervalMonthDayNanoHolder h2) {
        h2.months = this.holder.months;
        h2.days = this.holder.days;
        h2.nanoseconds = this.holder.nanoseconds;
    }

    @Override
    public void read(NullableIntervalMonthDayNanoHolder h2) {
        h2.months = this.holder.months;
        h2.days = this.holder.days;
        h2.nanoseconds = this.holder.nanoseconds;
        h2.isSet = this.isSet() ? 1 : 0;
    }

    @Override
    public PeriodDuration readPeriodDuration() {
        return new PeriodDuration(Period.ofMonths(this.holder.months).plusDays(this.holder.days), Duration.ofNanos(this.holder.nanoseconds));
    }

    @Override
    public Object readObject() {
        return this.readPeriodDuration();
    }

    @Override
    public void copyAsValue(IntervalMonthDayNanoWriter writer) {
        writer.write(this.holder);
    }
}

