/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auth.oauth2;

import com.google.cloud.spark.bigquery.repackaged.com.google.auth.oauth2.ActingParty;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import javax.annotation.Nullable;

public final class StsTokenExchangeRequest {
    private static final String GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private final String subjectToken;
    private final String subjectTokenType;
    @Nullable
    private final ActingParty actingParty;
    @Nullable
    private final List<String> scopes;
    @Nullable
    private final String resource;
    @Nullable
    private final String audience;
    @Nullable
    private final String requestedTokenType;
    @Nullable
    private final String internalOptions;

    private StsTokenExchangeRequest(String subjectToken, String subjectTokenType, @Nullable ActingParty actingParty, @Nullable List<String> scopes, @Nullable String resource, @Nullable String audience, @Nullable String requestedTokenType, @Nullable String internalOptions) {
        this.subjectToken = Preconditions.checkNotNull(subjectToken);
        this.subjectTokenType = Preconditions.checkNotNull(subjectTokenType);
        this.actingParty = actingParty;
        this.scopes = scopes;
        this.resource = resource;
        this.audience = audience;
        this.requestedTokenType = requestedTokenType;
        this.internalOptions = internalOptions;
    }

    public static Builder newBuilder(String subjectToken, String subjectTokenType) {
        return new Builder(subjectToken, subjectTokenType);
    }

    public String getGrantType() {
        return GRANT_TYPE;
    }

    public String getSubjectToken() {
        return this.subjectToken;
    }

    public String getSubjectTokenType() {
        return this.subjectTokenType;
    }

    @Nullable
    public String getResource() {
        return this.resource;
    }

    @Nullable
    public String getAudience() {
        return this.audience;
    }

    @Nullable
    public String getRequestedTokenType() {
        return this.requestedTokenType;
    }

    @Nullable
    public List<String> getScopes() {
        return this.scopes;
    }

    @Nullable
    public ActingParty getActingParty() {
        return this.actingParty;
    }

    @Nullable
    public String getInternalOptions() {
        return this.internalOptions;
    }

    public boolean hasResource() {
        return this.resource != null && !this.resource.isEmpty();
    }

    public boolean hasAudience() {
        return this.audience != null && !this.audience.isEmpty();
    }

    public boolean hasRequestedTokenType() {
        return this.requestedTokenType != null && !this.requestedTokenType.isEmpty();
    }

    public boolean hasScopes() {
        return this.scopes != null && !this.scopes.isEmpty();
    }

    public boolean hasActingParty() {
        return this.actingParty != null;
    }

    public static class Builder {
        private final String subjectToken;
        private final String subjectTokenType;
        @Nullable
        private String resource;
        @Nullable
        private String audience;
        @Nullable
        private String requestedTokenType;
        @Nullable
        private List<String> scopes;
        @Nullable
        private ActingParty actingParty;
        @Nullable
        private String internalOptions;

        private Builder(String subjectToken, String subjectTokenType) {
            this.subjectToken = subjectToken;
            this.subjectTokenType = subjectTokenType;
        }

        @CanIgnoreReturnValue
        public Builder setResource(String resource) {
            this.resource = resource;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setAudience(String audience) {
            this.audience = audience;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setRequestTokenType(String requestedTokenType) {
            this.requestedTokenType = requestedTokenType;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setScopes(List<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setActingParty(ActingParty actingParty) {
            this.actingParty = actingParty;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setInternalOptions(String internalOptions) {
            this.internalOptions = internalOptions;
            return this;
        }

        public StsTokenExchangeRequest build() {
            return new StsTokenExchangeRequest(this.subjectToken, this.subjectTokenType, this.actingParty, this.scopes, this.resource, this.audience, this.requestedTokenType, this.internalOptions);
        }
    }
}

