/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc;

import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc.JdbcExtractor;
import com.google.cloud.spark.bigquery.repackaged.io.openlineage.spark.shade.client.utils.jdbc.JdbcLocation;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenericJdbcExtractor
implements JdbcExtractor {
    private static Pattern URL_FORMAT = Pattern.compile("^(?<scheme>\\w+)://(?<authority>[\\w\\d\\.\\[\\]:,-]+)/?(?<database>[\\w\\d.]+)?(?:\\?.*)?");

    @Override
    public boolean isDefinedAt(String jdbcUri) {
        return true;
    }

    @Override
    public JdbcLocation extract(String rawUri, Properties properties) throws URISyntaxException {
        if (!rawUri.contains(",")) {
            return this.extractOneHost(rawUri);
        }
        return this.extractMultipleHosts(rawUri);
    }

    private JdbcLocation extractOneHost(String rawUri) throws URISyntaxException {
        URI uri = new URI(rawUri);
        if (uri.getHost() == null) {
            throw new URISyntaxException(rawUri, "Missing host");
        }
        String scheme = uri.getScheme();
        String host = uri.getHost();
        String authority = uri.getPort() > 0 ? String.format("%s:%d", host, uri.getPort()) : host;
        Optional<String> database = Optional.ofNullable(uri.getPath()).map(db -> db.replaceFirst("/", "")).filter(db -> !db.isEmpty());
        return new JdbcLocation(scheme, Optional.of(authority), Optional.empty(), database);
    }

    private JdbcLocation extractMultipleHosts(String rawUri) throws URISyntaxException {
        Matcher matcher = URL_FORMAT.matcher(rawUri);
        if (!matcher.matches()) {
            throw new URISyntaxException(rawUri, "Failed to parse jdbc url");
        }
        String scheme = matcher.group("scheme");
        String authority = matcher.group("authority");
        String database = matcher.group("database");
        return new JdbcLocation(scheme, Optional.ofNullable(authority), Optional.empty(), Optional.ofNullable(database));
    }
}

