/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.impl;

import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.common.MoreTypes;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.auto.service.AutoService;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableList;
import com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.squareup.javapoet.CodeBlock;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.Serializer;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.SerializerExtension;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.interfaces.SerializerFactory;
import com.google.cloud.spark.bigquery.repackaged.com.google.auto.value.extension.serializable.serializer.runtime.FunctionWithExceptions;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

@AutoService(value={SerializerExtension.class})
public final class ImmutableListSerializerExtension
implements SerializerExtension {
    @Override
    public Optional<Serializer> getSerializer(TypeMirror typeMirror, SerializerFactory factory, ProcessingEnvironment processingEnv) {
        if (!ImmutableListSerializerExtension.isImmutableList(typeMirror)) {
            return Optional.empty();
        }
        TypeMirror containedType = ImmutableListSerializerExtension.getContainedType(typeMirror);
        Serializer containedTypeSerializer = factory.getSerializer(containedType);
        if (containedTypeSerializer.isIdentity()) {
            return Optional.empty();
        }
        return Optional.of(new ImmutableListSerializer(containedTypeSerializer, factory, processingEnv));
    }

    private static boolean isImmutableList(TypeMirror type) {
        if (type.getKind() != TypeKind.DECLARED) {
            return false;
        }
        return MoreTypes.asTypeElement(type).getQualifiedName().contentEquals("com.google.cloud.spark.bigquery.repackaged.autovalue.shaded.com.google.common.collect.ImmutableList");
    }

    private static TypeMirror getContainedType(TypeMirror type) {
        return MoreTypes.asDeclared(type).getTypeArguments().get(0);
    }

    private static class ImmutableListSerializer
    implements Serializer {
        private final Serializer containedTypeSerializer;
        private final SerializerFactory factory;
        private final ProcessingEnvironment processingEnv;

        ImmutableListSerializer(Serializer containedTypeSerializer, SerializerFactory factory, ProcessingEnvironment processingEnv) {
            this.containedTypeSerializer = containedTypeSerializer;
            this.factory = factory;
            this.processingEnv = processingEnv;
        }

        @Override
        public TypeMirror proxyFieldType() {
            TypeElement immutableListTypeElement = this.processingEnv.getElementUtils().getTypeElement(ImmutableList.class.getCanonicalName());
            TypeMirror containedProxyType = this.containedTypeSerializer.proxyFieldType();
            return this.processingEnv.getTypeUtils().getDeclaredType(immutableListTypeElement, containedProxyType);
        }

        @Override
        public CodeBlock toProxy(CodeBlock expression) {
            CodeBlock element = this.factory.newIdentifier("value");
            return CodeBlock.of("$L.stream().map($T.wrapper($L -> $L)).collect($T.toImmutableList())", expression, FunctionWithExceptions.class, element, this.containedTypeSerializer.toProxy(element), ImmutableList.class);
        }

        @Override
        public CodeBlock fromProxy(CodeBlock expression) {
            CodeBlock element = this.factory.newIdentifier("value");
            return CodeBlock.of("$L.stream().map($T.wrapper($L -> $L)).collect($T.toImmutableList())", expression, FunctionWithExceptions.class, element, this.containedTypeSerializer.fromProxy(element), ImmutableList.class);
        }
    }
}

