/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.util;

import com.google.cloud.spark.bigquery.repackaged.com.google.rpc.RetryInfo;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Metadata;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.Status;
import com.google.cloud.spark.bigquery.repackaged.io.grpc.protobuf.ProtoUtils;
import java.time.Duration;

public class Errors {
    private static final Metadata.Key<RetryInfo> KEY_RETRY_INFO = ProtoUtils.keyForProto(RetryInfo.getDefaultInstance());

    private Errors() {
    }

    public static IsRetryableStatusResult isRetryableStatus(Status status, Metadata metadata) {
        RetryInfo retryInfo;
        IsRetryableStatusResult result = new IsRetryableStatusResult();
        result.isRetryable = Errors.isRetryableInternalStatus(status);
        if (!result.isRetryable && status.getCode() == Status.Code.RESOURCE_EXHAUSTED && metadata != null && metadata.containsKey(KEY_RETRY_INFO) && (retryInfo = metadata.get(KEY_RETRY_INFO)).hasRetryDelay()) {
            result.isRetryable = true;
            result.retryDelay = Duration.ofSeconds(retryInfo.getRetryDelay().getSeconds(), retryInfo.getRetryDelay().getNanos());
        }
        return result;
    }

    public static boolean isRetryableInternalStatus(Status status) {
        String description = status.getDescription();
        return status.getCode() == Status.Code.INTERNAL && description != null && (description.contains("Received unexpected EOS ") || description.contains(" Rst ") || description.contains("Rst Stream") || description.contains("RST_STREAM") || description.contains("INTERNAL: A retriable error could not be retried due to Extensible Stubs memory limits for streams") || description.contains("Connection closed with unknown cause") || description.contains("HTTP/2 error code: INTERNAL_ERROR"));
    }

    public static class IsRetryableStatusResult {
        public boolean isRetryable = false;
        public Duration retryDelay = null;
    }
}

