/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spark.bigquery.repackaged.com.google.cloud.bigquery.storage.v1;

import com.google.cloud.spark.bigquery.repackaged.com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.spark.bigquery.repackaged.com.google.api.resourcenames.ResourceName;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.base.Preconditions;
import com.google.cloud.spark.bigquery.repackaged.com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReadStreamName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SESSION_STREAM = PathTemplate.createWithoutUrlEncoding("projects/{project}/locations/{location}/sessions/{session}/streams/{stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String session;
    private final String stream;

    @Deprecated
    protected ReadStreamName() {
        this.project = null;
        this.location = null;
        this.session = null;
        this.stream = null;
    }

    private ReadStreamName(Builder builder) {
        this.project = Preconditions.checkNotNull(builder.getProject());
        this.location = Preconditions.checkNotNull(builder.getLocation());
        this.session = Preconditions.checkNotNull(builder.getSession());
        this.stream = Preconditions.checkNotNull(builder.getStream());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSession() {
        return this.session;
    }

    public String getStream() {
        return this.stream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReadStreamName of(String project, String location, String session, String stream) {
        return ReadStreamName.newBuilder().setProject(project).setLocation(location).setSession(session).setStream(stream).build();
    }

    public static String format(String project, String location, String session, String stream) {
        return ReadStreamName.newBuilder().setProject(project).setLocation(location).setSession(session).setStream(stream).build().toString();
    }

    public static ReadStreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map<String, String> matchMap = PROJECT_LOCATION_SESSION_STREAM.validatedMatch(formattedString, "ReadStreamName.parse: formattedString not in valid format");
        return ReadStreamName.of(matchMap.get("project"), matchMap.get("location"), matchMap.get("session"), matchMap.get("stream"));
    }

    public static List<ReadStreamName> parseList(List<String> formattedStrings) {
        ArrayList<ReadStreamName> list = new ArrayList<ReadStreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReadStreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReadStreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReadStreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SESSION_STREAM.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReadStreamName readStreamName = this;
            synchronized (readStreamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder<String, String> fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put("project", this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put("location", this.location);
                    }
                    if (this.session != null) {
                        fieldMapBuilder.put("session", this.session);
                    }
                    if (this.stream != null) {
                        fieldMapBuilder.put("stream", this.stream);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SESSION_STREAM.instantiate("project", this.project, "location", this.location, "session", this.session, "stream", this.stream);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReadStreamName that = (ReadStreamName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.session, that.session) && Objects.equals(this.stream, that.stream);
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.project);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.location);
        h2 *= 1000003;
        h2 ^= Objects.hashCode(this.session);
        h2 *= 1000003;
        return h2 ^= Objects.hashCode(this.stream);
    }

    public static class Builder {
        private String project;
        private String location;
        private String session;
        private String stream;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSession() {
            return this.session;
        }

        public String getStream() {
            return this.stream;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        public Builder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        private Builder(ReadStreamName readStreamName) {
            this.project = readStreamName.project;
            this.location = readStreamName.location;
            this.session = readStreamName.session;
            this.stream = readStreamName.stream;
        }

        public ReadStreamName build() {
            return new ReadStreamName(this);
        }
    }
}

